/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Member;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class JavaMethod
extends AbstractInheritableJavaEntity
implements Member {
    private TypeVariable[] typeParameters = TypeVariable.EMPTY_ARRAY;
    private Type returns = Type.VOID;
    private List parameters = new LinkedList();
    private JavaParameter[] parametersArray = JavaParameter.EMPTY_ARRAY;
    private Type[] exceptions = Type.EMPTY_ARRAY;
    private boolean constructor;
    private String sourceCode;
    private boolean varArgs;

    public JavaMethod() {
    }

    public JavaMethod(String name) {
        this.setName(name);
    }

    public JavaMethod(Type returns, String name) {
        this.setReturns(returns);
        this.setName(name);
    }

    public Type getReturns() {
        return this.returns;
    }

    public JavaParameter[] getParameters() {
        if (this.parametersArray == null) {
            this.parametersArray = new JavaParameter[this.parameters.size()];
            this.parameters.toArray(this.parametersArray);
        }
        return this.parametersArray;
    }

    public JavaParameter getParameterByName(String name) {
        JavaParameter[] parameters = this.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (!parameters[i2].getName().equals(name)) continue;
            return parameters[i2];
        }
        return null;
    }

    public Type[] getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    protected void writeBody(IndentBuffer result) {
        this.writeBody(result, true, true, true);
    }

    protected void writeBody(IndentBuffer result, boolean withModifiers, boolean isDeclaration, boolean isPrettyPrint) {
        int i2;
        if (withModifiers) {
            this.writeAccessibilityModifier(result);
            this.writeNonAccessibilityModifiers(result);
        }
        if (!this.constructor && isDeclaration) {
            result.write(this.returns.toString());
            result.write(' ');
        }
        result.write(this.name);
        result.write('(');
        for (i2 = 0; i2 < this.getParameters().length; ++i2) {
            JavaParameter parameter = this.parametersArray[i2];
            if (i2 > 0) {
                result.write(", ");
            }
            if (isDeclaration) {
                result.write(parameter.getType().toString());
                if (parameter.isVarArgs()) {
                    result.write("...");
                }
                result.write(' ');
            }
            result.write(parameter.getName());
        }
        result.write(')');
        if (isDeclaration && this.exceptions.length > 0) {
            result.write(" throws ");
            for (i2 = 0; i2 < this.exceptions.length; ++i2) {
                if (i2 > 0) {
                    result.write(", ");
                }
                result.write(this.exceptions[i2].getValue());
            }
        }
        if (isPrettyPrint) {
            if (this.sourceCode != null && this.sourceCode.length() > 0) {
                result.write(" {");
                result.newline();
                result.write(this.sourceCode);
                result.write("}");
                result.newline();
            } else {
                result.write(';');
                result.newline();
            }
        }
    }

    private String getSignature(boolean withModifiers, boolean isDeclaration) {
        IndentBuffer result = new IndentBuffer();
        this.writeBody(result, withModifiers, isDeclaration, false);
        return result.toString();
    }

    public String getDeclarationSignature(boolean withModifiers) {
        return this.getSignature(withModifiers, true);
    }

    public String getCallSignature() {
        return this.getSignature(false, false);
    }

    public void setReturns(Type returns) {
        this.returns = returns;
    }

    public void addParameter(JavaParameter javaParameter) {
        javaParameter.setParentMethod(this);
        this.parameters.add(javaParameter);
        this.parametersArray = null;
        this.varArgs = javaParameter.isVarArgs();
    }

    public void setExceptions(Type[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaMethod)) {
            return false;
        }
        JavaMethod m = (JavaMethod)obj;
        if (m.isConstructor() != this.isConstructor()) {
            return false;
        }
        if (m.getName() != null && !m.getName().equals(this.getName())) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(m.getName())) {
            return false;
        }
        if (m.getReturns() != null && !m.getReturns().equals(this.getReturns())) {
            return false;
        }
        if (this.getReturns() != null && !this.getReturns().equals(m.getReturns())) {
            return false;
        }
        JavaParameter[] myParams = this.getParameters();
        JavaParameter[] otherParams = m.getParameters();
        if (otherParams.length != myParams.length) {
            return false;
        }
        for (int i2 = 0; i2 < myParams.length; ++i2) {
            if (otherParams[i2].equals(myParams[i2])) continue;
            return false;
        }
        return this.varArgs == m.varArgs;
    }

    public boolean signatureMatches(String name, Type[] parameterTypes) {
        return this.signatureMatches(name, parameterTypes, false);
    }

    public boolean signatureMatches(String name, Type[] parameterTypes, boolean varArg) {
        if (!name.equals(this.name)) {
            return false;
        }
        Type[] typeArray = parameterTypes = parameterTypes == null ? new Type[]{} : parameterTypes;
        if (parameterTypes.length != this.getParameters().length) {
            return false;
        }
        for (int i2 = 0; i2 < this.parametersArray.length; ++i2) {
            if (this.parametersArray[i2].getType().equals(parameterTypes[i2])) continue;
            return false;
        }
        return this.varArgs == varArg;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        if (this.returns != null) {
            hashCode *= this.returns.hashCode();
        }
        return hashCode *= this.getParameters().length;
    }

    public boolean isPublic() {
        return super.isPublic() || this.getParentClass() != null && this.getParentClass().isInterface();
    }

    public boolean isPropertyAccessor() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().length != 0) {
            return false;
        }
        if (this.getName().startsWith("is")) {
            return this.getName().length() > 2 && Character.isUpperCase(this.getName().charAt(2));
        }
        if (this.getName().startsWith("get")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    public boolean isPropertyMutator() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().length != 1) {
            return false;
        }
        if (this.getName().startsWith("set")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    public Type getPropertyType() {
        if (this.isPropertyAccessor()) {
            return this.getReturns();
        }
        if (this.isPropertyMutator()) {
            return this.getParameters()[0].getType();
        }
        return null;
    }

    public String getPropertyName() {
        int start = -1;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            start = 3;
        } else if (this.getName().startsWith("is")) {
            start = 2;
        } else {
            return null;
        }
        return Introspector.decapitalize(this.getName().substring(start));
    }

    public DocletTag[] getTagsByName(String name, boolean inherited) {
        JavaClass clazz = this.getParentClass();
        JavaParameter[] params = this.getParameters();
        Type[] types = new Type[params.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = params[i2].getType();
        }
        JavaMethod[] methods = clazz.getMethodsBySignature(this.getName(), types, true);
        ArrayList<DocletTag> result = new ArrayList<DocletTag>();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            JavaMethod method = methods[i3];
            DocletTag[] tags = method.getTagsByName(name);
            for (int j = 0; j < tags.length; ++j) {
                DocletTag tag = tags[j];
                if (result.contains(tag)) continue;
                result.add(tag);
            }
        }
        return result.toArray(new DocletTag[result.size()]);
    }

    public int compareTo(Object o) {
        return this.getDeclarationSignature(false).compareTo(((JavaMethod)o).getDeclarationSignature(false));
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void setTypeParameters(TypeVariable[] typeParameters) {
        this.typeParameters = typeParameters;
    }

    public TypeVariable[] getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isNative()) {
            result.append("native ");
        }
        if (!this.constructor) {
            result.append(this.getReturns().getValue() + " ");
        }
        if (this.getParentClass() != null) {
            result.append(this.getParentClass().getFullyQualifiedName());
            if (!this.constructor) {
                result.append(".");
            }
        }
        if (!this.constructor) {
            result.append(this.getName());
        }
        result.append("(");
        for (int paramIndex = 0; paramIndex < this.getParameters().length; ++paramIndex) {
            if (paramIndex > 0) {
                result.append(",");
            }
            String typeValue = this.getParameters()[paramIndex].getType().getResolvedValue(this.getTypeParameters());
            result.append(typeValue);
        }
        result.append(")");
        for (int i2 = 0; i2 < this.exceptions.length; ++i2) {
            result.append(i2 == 0 ? " throws " : ",");
            result.append(this.exceptions[i2].getValue());
        }
        return result.toString();
    }

    public Type getGenericReturnType() {
        return this.returns;
    }

    public Type getReturnType() {
        return this.getReturnType(false);
    }

    public Type getReturnType(boolean resolve) {
        return this.getReturnType(resolve, this.getParentClass());
    }

    protected Type getReturnType(boolean resolve, JavaClass callingClass) {
        Type result = null;
        if (this.getReturns() != null) {
            result = this.getReturns().resolve(this.getParentClass(), callingClass);
            if (!resolve && !this.returns.getFullyQualifiedName().equals(result.getFullyQualifiedName())) {
                result = new Type("java.lang.Object");
            }
        }
        return result;
    }

    public Type[] getParameterTypes() {
        return this.getParameterTypes(false);
    }

    public Type[] getParameterTypes(boolean resolve) {
        return this.getParameterTypes(resolve, this.getParentClass());
    }

    protected Type[] getParameterTypes(boolean resolve, JavaClass callingClass) {
        Type[] result = new Type[this.getParameters().length];
        for (int paramIndex = 0; paramIndex < this.getParameters().length; ++paramIndex) {
            Type curType = this.getParameters()[paramIndex].getType().resolve(this.getParentClass(), callingClass);
            result[paramIndex] = !resolve && this.returns != null && !this.returns.getFullyQualifiedName().equals(curType.getFullyQualifiedName()) ? new Type("java.lang.Object") : curType;
        }
        return result;
    }
}

