/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.selectors.Type;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Checksum
extends MatchingTask
implements Condition {
    private static final int NIBBLE = 4;
    private static final int WORD = 16;
    private static final int BUFFER_SIZE = 8192;
    private static final int BYTE_MASK = 255;
    private File file = null;
    private File todir;
    private String algorithm = "MD5";
    private String provider = null;
    private String fileext;
    private String property;
    private Map<File, byte[]> allDigests = new HashMap<File, byte[]>();
    private Map<File, String> relativeFilePaths = new HashMap<File, String>();
    private String totalproperty;
    private boolean forceOverwrite;
    private String verifyProperty;
    private FileUnion resources = null;
    private Hashtable<File, Object> includeFileMap = new Hashtable();
    private MessageDigest messageDigest;
    private boolean isCondition;
    private int readBufferSize = 8192;
    private MessageFormat format = FormatElement.getDefault().getFormat();

    public void setFile(File file) {
        this.file = file;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setFileext(String fileext) {
        this.fileext = fileext;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setTotalproperty(String totalproperty) {
        this.totalproperty = totalproperty;
    }

    public void setVerifyproperty(String verifyProperty) {
        this.verifyProperty = verifyProperty;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void setReadBufferSize(int size) {
        this.readBufferSize = size;
    }

    public void setFormat(FormatElement e) {
        this.format = e.getFormat();
    }

    public void setPattern(String p) {
        this.format = new MessageFormat(p);
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void add(ResourceCollection rc) {
        if (rc == null) {
            return;
        }
        this.resources = this.resources == null ? new FileUnion() : this.resources;
        this.resources.add(rc);
    }

    public void execute() throws BuildException {
        this.isCondition = false;
        boolean value = this.validateAndExecute();
        if (this.verifyProperty != null) {
            this.getProject().setNewProperty(this.verifyProperty, value ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
    }

    public boolean eval() throws BuildException {
        this.isCondition = true;
        return this.validateAndExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAndExecute() throws BuildException {
        String savedFileExt = this.fileext;
        if (this.file == null && (this.resources == null || this.resources.size() == 0)) {
            throw new BuildException("Specify at least one source - a file or a resource collection.");
        }
        if (this.resources != null && !this.resources.isFilesystemOnly()) {
            throw new BuildException("Can only calculate checksums for file-based resources.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Checksum cannot be generated for directories");
        }
        if (this.file != null && this.totalproperty != null) {
            throw new BuildException("File and Totalproperty cannot co-exist.");
        }
        if (this.property != null && this.fileext != null) {
            throw new BuildException("Property and FileExt cannot co-exist.");
        }
        if (this.property != null) {
            if (this.forceOverwrite) {
                throw new BuildException("ForceOverwrite cannot be used when Property is specified");
            }
            int ct = 0;
            if (this.resources != null) {
                ct += this.resources.size();
            }
            if (this.file != null) {
                ++ct;
            }
            if (ct > 1) {
                throw new BuildException("Multiple files cannot be used when Property is specified");
            }
        }
        if (this.verifyProperty != null) {
            this.isCondition = true;
        }
        if (this.verifyProperty != null && this.forceOverwrite) {
            throw new BuildException("VerifyProperty and ForceOverwrite cannot co-exist.");
        }
        if (this.isCondition && this.forceOverwrite) {
            throw new BuildException("ForceOverwrite cannot be used when conditions are being used.");
        }
        this.messageDigest = null;
        if (this.provider != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noalgo) {
                throw new BuildException(noalgo, this.getLocation());
            }
            catch (NoSuchProviderException noprovider) {
                throw new BuildException(noprovider, this.getLocation());
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noalgo) {
            throw new BuildException(noalgo, this.getLocation());
        }
        if (this.messageDigest == null) {
            throw new BuildException("Unable to create Message Digest", this.getLocation());
        }
        if (this.fileext == null) {
            this.fileext = "." + this.algorithm;
        } else if (this.fileext.trim().length() == 0) {
            throw new BuildException("File extension when specified must not be an empty string");
        }
        try {
            if (this.resources != null) {
                for (Resource r : this.resources) {
                    File src = r.as(FileProvider.class).getFile();
                    if (this.totalproperty != null || this.todir != null) {
                        this.relativeFilePaths.put(src, r.getName().replace(File.separatorChar, '/'));
                    }
                    this.addToIncludeFileMap(src);
                }
            }
            if (this.file != null) {
                if (this.totalproperty != null || this.todir != null) {
                    this.relativeFilePaths.put(this.file, this.file.getName().replace(File.separatorChar, '/'));
                }
                this.addToIncludeFileMap(this.file);
            }
            boolean bl = this.generateChecksums();
            return bl;
        }
        finally {
            this.fileext = savedFileExt;
            this.includeFileMap.clear();
        }
    }

    private void addToIncludeFileMap(File file) throws BuildException {
        if (file.exists()) {
            if (this.property == null) {
                File checksumFile = this.getChecksumFile(file);
                if (this.forceOverwrite || this.isCondition || file.lastModified() > checksumFile.lastModified()) {
                    this.includeFileMap.put(file, checksumFile);
                } else {
                    this.log(file + " omitted as " + checksumFile + " is up to date.", 3);
                    if (this.totalproperty != null) {
                        String checksum = this.readChecksum(checksumFile);
                        byte[] digest = Checksum.decodeHex(checksum.toCharArray());
                        this.allDigests.put(file, digest);
                    }
                }
            } else {
                this.includeFileMap.put(file, this.property);
            }
        } else {
            String message = "Could not find file " + file.getAbsolutePath() + " to generate checksum for.";
            this.log(message);
            throw new BuildException(message, this.getLocation());
        }
    }

    private File getChecksumFile(File file) {
        File directory;
        if (this.todir != null) {
            String path = this.getRelativeFilePath(file);
            directory = new File(this.todir, path).getParentFile();
            directory.mkdirs();
        } else {
            directory = file.getParentFile();
        }
        File checksumFile = new File(directory, file.getName() + this.fileext);
        return checksumFile;
    }

    private boolean generateChecksums() throws BuildException {
        boolean checksumMatches = true;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] buf = new byte[this.readBufferSize];
        try {
            for (Map.Entry<File, Object> entry : this.includeFileMap.entrySet()) {
                this.messageDigest.reset();
                File src = entry.getKey();
                if (!this.isCondition) {
                    this.log("Calculating " + this.algorithm + " checksum for " + src, 3);
                }
                fis = new FileInputStream(src);
                DigestInputStream dis = new DigestInputStream(fis, this.messageDigest);
                while (dis.read(buf, 0, this.readBufferSize) != -1) {
                }
                dis.close();
                fis.close();
                fis = null;
                byte[] fileDigest = this.messageDigest.digest();
                if (this.totalproperty != null) {
                    this.allDigests.put(src, fileDigest);
                }
                String checksum = this.createDigestString(fileDigest);
                Object destination = entry.getValue();
                if (destination instanceof String) {
                    String prop = (String)destination;
                    if (this.isCondition) {
                        checksumMatches = checksumMatches && checksum.equals(this.property);
                        continue;
                    }
                    this.getProject().setNewProperty(prop, checksum);
                    continue;
                }
                if (!(destination instanceof File)) continue;
                if (this.isCondition) {
                    File existingFile = (File)destination;
                    if (existingFile.exists()) {
                        try {
                            String suppliedChecksum = this.readChecksum(existingFile);
                            checksumMatches = checksumMatches && checksum.equals(suppliedChecksum);
                        }
                        catch (BuildException be) {
                            checksumMatches = false;
                        }
                        continue;
                    }
                    checksumMatches = false;
                    continue;
                }
                File dest = (File)destination;
                fos = new FileOutputStream(dest);
                fos.write(this.format.format(new Object[]{checksum, src.getName(), FileUtils.getRelativePath(dest.getParentFile(), src), FileUtils.getRelativePath(this.getProject().getBaseDir(), src), src.getAbsolutePath()}).getBytes());
                fos.write(StringUtils.LINE_SEP.getBytes());
                fos.close();
                fos = null;
            }
            if (this.totalproperty != null) {
                File[] keyArray = this.allDigests.keySet().toArray(new File[this.allDigests.size()]);
                Arrays.sort(keyArray, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1 == null ? (f2 == null ? 0 : -1) : (f2 == null ? 1 : Checksum.this.getRelativeFilePath(f1).compareTo(Checksum.this.getRelativeFilePath(f2)));
                    }
                });
                this.messageDigest.reset();
                for (File src : keyArray) {
                    byte[] digest = this.allDigests.get(src);
                    this.messageDigest.update(digest);
                    String fileName = this.getRelativeFilePath(src);
                    this.messageDigest.update(fileName.getBytes());
                }
                String string = this.createDigestString(this.messageDigest.digest());
                this.getProject().setNewProperty(this.totalproperty, string);
            }
        }
        catch (Exception e) {
            throw new BuildException(e, this.getLocation());
        }
        finally {
            FileUtils.close(fis);
            FileUtils.close(fos);
        }
        return checksumMatches;
    }

    private String createDigestString(byte[] fileDigest) {
        StringBuilder checksumSb = new StringBuilder();
        for (byte digestByte : fileDigest) {
            String hexStr = Integer.toHexString(0xFF & digestByte);
            if (hexStr.length() < 2) {
                checksumSb.append("0");
            }
            checksumSb.append(hexStr);
        }
        return checksumSb.toString();
    }

    public static byte[] decodeHex(char[] data) throws BuildException {
        int l = data.length;
        if ((l & 1) != 0) {
            throw new BuildException("odd number of characters.");
        }
        byte[] out = new byte[l >> 1];
        int i2 = 0;
        int j = 0;
        while (j < l) {
            int f = Character.digit(data[j++], 16) << 4;
            out[i2] = (byte)((f |= Character.digit(data[j++], 16)) & 0xFF);
            ++i2;
        }
        return out;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readChecksum(File f) {
        String string;
        BufferedReader diskChecksumReader = null;
        try {
            diskChecksumReader = new BufferedReader(new FileReader(f));
            Object[] result = this.format.parse(diskChecksumReader.readLine());
            if (result == null || result.length == 0 || result[0] == null) {
                throw new BuildException("failed to find a checksum");
            }
            string = (String)result[0];
        }
        catch (IOException e) {
            try {
                throw new BuildException("Couldn't read checksum file " + f, e);
                catch (ParseException e2) {
                    throw new BuildException("Couldn't read checksum file " + f, e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(diskChecksumReader);
                throw throwable;
            }
        }
        FileUtils.close(diskChecksumReader);
        return string;
    }

    private String getRelativeFilePath(File f) {
        String path = this.relativeFilePaths.get(f);
        if (path == null) {
            throw new BuildException("Internal error: relativeFilePaths could not match file " + f + "\nplease file a bug report on this");
        }
        return path;
    }

    public static class FormatElement
    extends EnumeratedAttribute {
        private static HashMap<String, MessageFormat> formatMap = new HashMap();
        private static final String CHECKSUM = "CHECKSUM";
        private static final String MD5SUM = "MD5SUM";
        private static final String SVF = "SVF";

        public static FormatElement getDefault() {
            FormatElement e = new FormatElement();
            e.setValue(CHECKSUM);
            return e;
        }

        public MessageFormat getFormat() {
            return formatMap.get(this.getValue());
        }

        public String[] getValues() {
            return new String[]{CHECKSUM, MD5SUM, SVF};
        }

        static {
            formatMap.put(CHECKSUM, new MessageFormat("{0}"));
            formatMap.put(MD5SUM, new MessageFormat("{0} *{1}"));
            formatMap.put(SVF, new MessageFormat("MD5 ({1}) = {0}"));
        }
    }

    private static class FileUnion
    extends Restrict {
        private Union u = new Union();

        FileUnion() {
            super.add(this.u);
            super.add(Type.FILE);
        }

        public void add(ResourceCollection rc) {
            this.u.add(rc);
        }
    }
}

