/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.launcher.Java13CommandLauncher;
import org.apache.tools.ant.util.FileUtils;

public class VmsCommandLauncher
extends Java13CommandLauncher {
    public Process exec(Project project, String[] cmd, String[] env) throws IOException {
        File cmdFile = this.createCommandFile(cmd, env);
        Process p = super.exec(project, new String[]{cmdFile.getPath()}, env);
        this.deleteAfter(cmdFile, p);
        return p;
    }

    public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
        File cmdFile = this.createCommandFile(cmd, env);
        Process p = super.exec(project, new String[]{cmdFile.getPath()}, env, workingDir);
        this.deleteAfter(cmdFile, p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCommandFile(String[] cmd, String[] env) throws IOException {
        File script = FILE_UTILS.createTempFile("ANT", ".COM", null, true, true);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(script));
            if (env != null) {
                for (String variable : env) {
                    int eqIndex = variable.indexOf(61);
                    if (eqIndex == -1) continue;
                    out.write("$ DEFINE/NOLOG ");
                    out.write(variable.substring(0, eqIndex));
                    out.write(" \"");
                    out.write(variable.substring(eqIndex + 1));
                    out.write(34);
                    out.newLine();
                }
            }
            out.write("$ " + cmd[0]);
            for (int i2 = 1; i2 < cmd.length; ++i2) {
                out.write(" -");
                out.newLine();
                out.write(cmd[i2]);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
        return script;
    }

    private void deleteAfter(final File f, final Process p) {
        new Thread(){

            public void run() {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FileUtils.delete(f);
            }
        }.start();
    }
}

