/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarResource
extends ArchiveResource {
    private String userName = "";
    private String groupName = "";
    private int uid;
    private int gid;

    public TarResource() {
    }

    public TarResource(File a, TarEntry e) {
        super(a, true);
        this.setEntry(e);
    }

    public TarResource(Resource a, TarEntry e) {
        super(a, true);
        this.setEntry(e);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        Resource archive = this.getArchive();
        TarInputStream i2 = new TarInputStream(archive.getInputStream());
        TarEntry te = null;
        while ((te = i2.getNextEntry()) != null) {
            if (!te.getName().equals(this.getName())) continue;
            return i2;
        }
        FileUtils.close(i2);
        throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the tar task for tar output.");
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUserName();
        }
        this.checkEntry();
        return this.userName;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGroup();
        }
        this.checkEntry();
        return this.groupName;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUid();
        }
        this.checkEntry();
        return this.uid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGid();
        }
        this.checkEntry();
        return this.gid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchEntry() {
        TarInputStream i2;
        block6: {
            block5: {
                Resource archive = this.getArchive();
                i2 = null;
                try {
                    try {
                        i2 = new TarInputStream(archive.getInputStream());
                        TarEntry te = null;
                        while ((te = i2.getNextEntry()) != null) {
                            if (!te.getName().equals(this.getName())) continue;
                            this.setEntry(te);
                            Object var5_5 = null;
                            break block5;
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        this.log(e.getMessage(), 4);
                        throw new BuildException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    FileUtils.close(i2);
                    throw throwable;
                }
            }
            FileUtils.close(i2);
            return;
        }
        Object var5_6 = null;
        FileUtils.close(i2);
        this.setEntry(null);
    }

    private void setEntry(TarEntry e) {
        if (e == null) {
            this.setExists(false);
            return;
        }
        this.setName(e.getName());
        this.setExists(true);
        this.setLastModified(e.getModTime().getTime());
        this.setDirectory(e.isDirectory());
        this.setSize(e.getSize());
        this.setMode(e.getMode());
        this.userName = e.getUserName();
        this.groupName = e.getGroupName();
        this.uid = e.getUserId();
        this.gid = e.getGroupId();
    }
}

