/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Parameters;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.junit.IJUnitTestRunner;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final String JUNIT_4_TESTRUNNER = "org.testng.junit.JUnit4TestRunner";
    private static final List<ClassLoader> classLoaders = new Vector<ClassLoader>();
    private static final String CANNOT_INSTANTIATE_CLASS = "Cannot instantiate class ";
    private static final String CLASS_HELPER = ClassHelper.class.getSimpleName();
    private static final String SKIP_CALLER_CLS_LOADER = "skip.caller.clsLoader";
    private static int lastGoodRootIndex = -1;

    private ClassHelper() {
    }

    public static void addClassLoader(ClassLoader classLoader) {
        classLoaders.add(classLoader);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | SecurityException throwable) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), throwable);
        }
    }

    public static <T> T newInstanceOrNull(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return ClassHelper.newInstance(constructor, new Object[0]);
        }
        catch (ExceptionInInitializerError | SecurityException throwable) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... objectArray) {
        try {
            return constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + constructor.getDeclaringClass().getName(), reflectiveOperationException);
        }
    }

    public static Class<?> forName(String string) {
        List<ClassLoader> list = Lists.newArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            list.add(classLoader);
        }
        list.addAll(classLoaders);
        for (ClassLoader classLoader2 : list) {
            if (null == classLoader2) continue;
            try {
                return classLoader2.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!classLoaders.isEmpty()) continue;
                ClassHelper.logClassNotFoundError(string, classNotFoundException);
            }
        }
        if (Boolean.parseBoolean(System.getProperty(SKIP_CALLER_CLS_LOADER))) {
            return null;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassHelper.logClassNotFoundError(string, classNotFoundException);
            return null;
        }
    }

    private static void logClassNotFoundError(String string, Exception exception) {
        Utils.log(CLASS_HELPER, 2, "Could not instantiate " + string + " : Class doesn't exist (" + exception.getMessage() + ")");
    }

    public static List<ConstructorOrMethod> findDeclaredFactoryMethods(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        ArrayList<ConstructorOrMethod> arrayList = new ArrayList<ConstructorOrMethod>();
        for (Method method : ClassHelper.getAvailableMethods(clazz)) {
            IFactoryAnnotation iFactoryAnnotation = iAnnotationFinder.findAnnotation(method, IFactoryAnnotation.class);
            if (iFactoryAnnotation == null) continue;
            Constructor<?> constructor = new ConstructorOrMethod(method);
            ((ConstructorOrMethod)((Object)constructor)).setEnabled(iFactoryAnnotation.getEnabled());
            arrayList.add((ConstructorOrMethod)((Object)constructor));
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            IFactoryAnnotation iFactoryAnnotation = iAnnotationFinder.findAnnotation(constructor, IFactoryAnnotation.class);
            if (iFactoryAnnotation == null) continue;
            ConstructorOrMethod constructorOrMethod = new ConstructorOrMethod(constructor);
            constructorOrMethod.setEnabled(iFactoryAnnotation.getEnabled());
            arrayList.add(constructorOrMethod);
        }
        return arrayList;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        Map<String, Set<Method>> map = Maps.newHashMap();
        for (Method entry : ReflectionHelper.getLocalMethods(clazz)) {
            ClassHelper.appendMethod(map, entry);
        }
        Object object = clazz.getSuperclass();
        if (null != object) {
            while (!Object.class.equals(object)) {
                Set<Map.Entry<String, Set<Method>>> set = ClassHelper.extractMethods(clazz, object, map).entrySet();
                for (Map.Entry<String, Set<Method>> entry : set) {
                    Set<Method> set2 = map.get(entry.getKey());
                    if (set2 == null) {
                        map.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    set2.addAll((Collection<Method>)entry.getValue());
                }
                object = ((Class)object).getSuperclass();
            }
        }
        Set<Method> set = Sets.newHashSet();
        for (Set<Method> set3 : map.values()) {
            set.addAll(set3);
        }
        return set;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner testRunner) {
        IJUnitTestRunner iJUnitTestRunner = null;
        try {
            Class.forName("org.junit.Test");
            Class<?> clazz = ClassHelper.forName(JUNIT_4_TESTRUNNER);
            if (clazz != null) {
                iJUnitTestRunner = (IJUnitTestRunner)clazz.newInstance();
                iJUnitTestRunner.setTestResultNotifier(testRunner);
            }
        }
        catch (Throwable throwable) {
            Utils.log(CLASS_HELPER, 2, "JUnit 4 was not found on the classpath");
            try {
                Class.forName("junit.framework.Test");
                Class<?> clazz = ClassHelper.forName(JUNIT_TESTRUNNER);
                if (clazz != null) {
                    iJUnitTestRunner = (IJUnitTestRunner)clazz.newInstance();
                    iJUnitTestRunner.setTestResultNotifier(testRunner);
                }
            }
            catch (Exception exception) {
                Utils.log(CLASS_HELPER, 2, "JUnit 3 was not found on the classpath");
                throw new TestNGException("Cannot create JUnit runner", exception);
            }
        }
        return iJUnitTestRunner;
    }

    private static void appendMethod(Map<String, Set<Method>> map, Method method) {
        Set<Method> set = map.get(method.getName());
        if (set == null) {
            set = Sets.newHashSet();
            map.put(method.getName(), set);
        }
        set.add(method);
    }

    private static Map<String, Set<Method>> extractMethods(Class<?> clazz, Class<?> clazz2, Map<String, Set<Method>> map) {
        Map<String, Set<Method>> map2 = Maps.newHashMap();
        Method[] methodArray = clazz2.getDeclaredMethods();
        Package package_ = clazz.getPackage();
        Package package_2 = clazz2.getPackage();
        boolean bl = ClassHelper.isSamePackage(package_, package_2);
        for (Method method : methodArray) {
            if (!ClassHelper.canInclude(bl, method, map)) continue;
            ClassHelper.appendMethod(map2, method);
        }
        return map2;
    }

    private static boolean canInclude(boolean bl, Method method, Map<String, Set<Method>> map) {
        int n = method.getModifiers();
        boolean bl2 = Modifier.isPublic(n) || Modifier.isProtected(n) || bl && !Modifier.isPrivate(n);
        boolean bl3 = !ClassHelper.isOverridden(method, map) && !Modifier.isAbstract(n);
        return bl2 && bl3;
    }

    private static boolean isSamePackage(Package package_, Package package_2) {
        boolean bl = false;
        if (null == package_ && null == package_2) {
            bl = true;
        }
        if (null != package_ && null != package_2) {
            bl = package_.getName().equals(package_2.getName());
        }
        return bl;
    }

    private static boolean isOverridden(Method method, Map<String, Set<Method>> map) {
        Set<Method> set = map.get(method.getName());
        if (set == null) {
            return false;
        }
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] classArray = method.getParameterTypes();
        for (Method method2 : set) {
            Class<?>[] classArray2 = method2.getParameterTypes();
            if (!clazz.isAssignableFrom(method2.getDeclaringClass()) || classArray.length != classArray2.length) continue;
            boolean bl = true;
            for (int j = 0; j < classArray.length; ++j) {
                if (classArray[j].equals(classArray2[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector xmlMethodSelector) {
        try {
            Class<?> clazz = Class.forName(xmlMethodSelector.getClassName());
            return (IMethodSelector)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new TestNGException("Couldn't find method selector : " + xmlMethodSelector.getClassName(), exception);
        }
    }

    public static Object createInstance(Class<?> clazz, Map<Class<?>, IClass> map, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder, ITestObjectFactory iTestObjectFactory) {
        if (iTestObjectFactory instanceof IObjectFactory) {
            return ClassHelper.createInstance1(clazz, map, xmlTest, iAnnotationFinder, (IObjectFactory)iTestObjectFactory);
        }
        if (iTestObjectFactory instanceof IObjectFactory2) {
            return ClassHelper.createInstance2(clazz, (IObjectFactory2)iTestObjectFactory);
        }
        throw new AssertionError((Object)("Unknown object factory type:" + iTestObjectFactory));
    }

    private static Object createInstance2(Class<?> clazz, IObjectFactory2 iObjectFactory2) {
        return iObjectFactory2.newInstance(clazz);
    }

    public static Object createInstance1(Class<?> clazz, Map<Class<?>, IClass> map, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder, IObjectFactory iObjectFactory) {
        Object object;
        block13: {
            object = null;
            try {
                Object object2;
                boolean bl;
                Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(iAnnotationFinder, clazz);
                if (null != constructor) {
                    IParametersAnnotation iParametersAnnotation = iAnnotationFinder.findAnnotation(constructor, IParametersAnnotation.class);
                    if (iParametersAnnotation != null) {
                        String[] stringArray = iParametersAnnotation.getValue();
                        Object[] objectArray = Parameters.createInstantiationParameters(constructor, "@Parameters", iAnnotationFinder, stringArray, xmlTest.getAllParameters(), xmlTest.getSuite());
                        object = iObjectFactory.newInstance(constructor, objectArray);
                    }
                    break block13;
                }
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Class<?> clazz2 = ClassHelper.getEnclosingClass(clazz);
                boolean bl2 = bl = 0 != (clazz.getModifiers() & 8);
                if (null != clazz2 && !bl) {
                    Object object3;
                    Object[] objectArray2;
                    classArray = new Class[]{clazz2};
                    object2 = map.get(clazz2);
                    if (null != object2) {
                        objectArray2 = object2.getInstances(false);
                        if (null == objectArray2 || objectArray2.length == 0) {
                            object3 = iObjectFactory.newInstance(clazz2.getConstructor(classArray), new Object[0]);
                            object2.addInstance(object3);
                            objectArray2 = new Object[]{object3};
                        }
                    } else {
                        objectArray2 = new Object[]{clazz2.newInstance()};
                    }
                    object3 = objectArray2[0];
                    objectArray = new Object[]{object3};
                }
                try {
                    object2 = clazz.getDeclaredConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object2 = clazz.getDeclaredConstructor(String.class);
                    objectArray = new Object[]{xmlTest.getName()};
                }
                object = iObjectFactory.newInstance((Constructor)object2, objectArray);
            }
            catch (TestNGException testNGException) {
                throw testNGException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Throwable throwable) {
                throw new TestNGException("An error occurred while instantiating class " + clazz.getName() + ": " + throwable.getMessage(), throwable);
            }
        }
        if (object == null && !Modifier.isPublic(clazz.getModifiers())) {
            throw new TestNGException("An error occurred while instantiating class " + clazz.getName() + ". Check to make sure it can be accessed/instantiated.");
        }
        return object;
    }

    private static Class<?> getEnclosingClass(Class<?> clazz) {
        Class<?> clazz2 = null;
        String string = clazz.getName();
        int n = string.indexOf(36);
        if (n != -1) {
            String string2 = string.substring(0, n);
            try {
                clazz2 = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(ClassHelper.class).error(classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        return clazz2;
    }

    private static Constructor<?> findAnnotatedConstructor(IAnnotationFinder iAnnotationFinder, Class<?> clazz) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            Object object;
            IParametersAnnotation iParametersAnnotation = iAnnotationFinder.findAnnotation(constructor, IParametersAnnotation.class);
            if (iParametersAnnotation != null) {
                Class<?>[] classArray;
                object = iParametersAnnotation.getValue();
                if (((String[])object).length != (classArray = constructor.getParameterTypes()).length) {
                    throw new TestNGException("Parameter count mismatch:  " + constructor + "\naccepts " + classArray.length + " parameters but the @Test annotation declares " + ((String[])object).length);
                }
                return constructor;
            }
            object = iAnnotationFinder.findAnnotation(constructor, IFactoryAnnotation.class);
            if (object == null) continue;
            return constructor;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> clazz) {
        T t;
        try {
            if (clazz.getModifiers() == 0) {
                return null;
            }
            Constructor<T> constructor = clazz.getConstructor(String.class);
            t = constructor.newInstance("Default test name");
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null && exception.getCause() != null) {
                string = exception.getCause().getMessage();
            }
            String string2 = "Could not create an instance of class " + clazz + (string != null ? ": " + string : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(string2);
        }
        return t;
    }

    public static Class<?> fileToClass(String string) {
        int n;
        CharSequence charSequence;
        Class<?> clazz = null;
        if (!string.endsWith(".class") && !string.endsWith(".java")) {
            if (string.startsWith("class ")) {
                string = string.substring("class ".length());
            }
            if (null == (clazz = ClassHelper.forName(string))) {
                throw new TestNGException("Cannot load class from file: " + string);
            }
            return clazz;
        }
        int n2 = string.lastIndexOf(".class");
        if (-1 == n2) {
            n2 = string.lastIndexOf(".java");
        }
        String string2 = string.substring(0, n2);
        String[] stringArray = string2.split("[/\\\\]", -1);
        if (-1 != lastGoodRootIndex) {
            charSequence = new StringBuilder(stringArray[lastGoodRootIndex]);
            for (n = lastGoodRootIndex + 1; n < stringArray.length; ++n) {
                ((StringBuilder)charSequence).append(".").append(stringArray[n]);
            }
            clazz = ClassHelper.forName(((StringBuilder)charSequence).toString());
            if (null != clazz) {
                return clazz;
            }
        }
        charSequence = "";
        for (n = stringArray.length - 1; n >= 0; --n) {
            clazz = ClassHelper.forName((String)(charSequence = ((String)charSequence).length() == 0 ? stringArray[n] : stringArray[n] + "." + (String)charSequence));
            if (null == clazz) continue;
            lastGoodRootIndex = n;
            break;
        }
        if (null == clazz) {
            throw new TestNGException("Cannot load class from file: " + string);
        }
        return clazz;
    }

    public static XmlClass[] findClassesInSameTest(Class<?> clazz, XmlSuite xmlSuite) {
        Set set = Sets.newHashSet();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            set.addAll(ClassHelper.findClassesInSameTest(clazz, xmlTest));
        }
        return set.toArray(new XmlClass[set.size()]);
    }

    private static Collection<XmlClass> findClassesInSameTest(Class<?> clazz, XmlTest xmlTest) {
        Set<XmlClass> set = Sets.newHashSet();
        String string = clazz.getName();
        for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
            if (!xmlClass.getName().equals(string)) continue;
            set.addAll(xmlTest.getXmlClasses());
            break;
        }
        return set;
    }
}

