const utils = require('../utils/utils');
const actionPlanService = require('../services/actionPlan');

exports.getActionPlan = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  try {
    const data = await actionPlanService.getActionPlan(userId);

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.setActiveActionPlan = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await actionPlanService.setActiveActionPlan(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.createUserActionPlan = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    id: actionPlanId = '', startDate = '', endDate = '', active = 0,
  } = req.body;

  if (!startDate || !endDate || !actionPlanId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await actionPlanService.createUserActionPlan(
      actionPlanId, userId, startDate, endDate, active,
    );

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
