const utils = require('../utils/utils');
const answerServices = require('../services/answer');

exports.getAnswers = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { suscriptionTypeId } = req.params;

  if (!userId || !suscriptionTypeId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await answerServices.getAnswers(userId, suscriptionTypeId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
