const utils = require('../utils/utils');
const faqServices = require('../services/faq');

exports.getFaqs = async (req, res) => {
  try {
    const data = await faqServices.getFaqs();

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
