const utils = require('../utils/utils');
const powerfulQuestionService = require('../services/powerfulQuestion');

exports.getPowerfulQuestions = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  try {
    const data = await powerfulQuestionService.getPowerfulQuestions(userId);

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.updateValuesPowerfulQuestions = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { powerfulQuestionsIds = [] } = req.body;

  if (!powerfulQuestionsIds) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await powerfulQuestionService.updateValuesPowerfulQuestions(
      powerfulQuestionsIds,
      userId,
    );

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
