const utils = require('../utils/utils');
const routesServices = require('../services/routes');

exports.setRoute = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { routeId = '' } = req.body;

  if (!routeId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await routesServices.setRoute(userId, routeId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.getRoutes = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  try {
    const data = await routesServices.getRoutes(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
