module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('behaviors', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    name: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'name',
    },
    info: {
      type: Sequelize.STRING(512),
      field: 'info',
    },
    strengthId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'strengths',
        key: 'id',
      },
      field: 'strength_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('behaviors'),
};
