module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('questionnarie_behaviors', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    questionnarieId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'questionnaries',
        key: 'id',
      },
      field: 'questionnarie_id',
    },
    behaviorId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'behaviors',
        key: 'id',
      },
      field: 'behavior_id',
    },
    behaviorPointId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'behavior_points',
        key: 'id',
      },
      field: 'behavior_point_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('questionnarie_behaviors'),
};
