module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_habits', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userAspectReinventationId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'user_aspects_reinventation',
        key: 'id',
      },
      field: 'user_aspect_reinventation_id',
    },
    habitId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'habits',
        key: 'id',
      },
      field: 'habit_id',
    },
    active: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      field: 'active',
    },
    days: {
      type: Sequelize.TEXT,
      field: 'days',
    },
    hour: {
      type: Sequelize.STRING(45),
      field: 'hour',
    },
    completedDate: {
      type: Sequelize.DATE,
      field: 'completed_date',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
    deletedAt: {
      type: Sequelize.DATE,
      field: 'deleted_at',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_habits'),
};
