module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('users', 'profile_image', {
        type: Sequelize.TEXT('long'),
        field: 'profile_image',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('users', 'profile_image');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
