module.exports = {
  up: (queryInterface, DataTypes) => queryInterface.createTable('design_strategies', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: DataTypes.INTEGER,
    },
    title: {
      allowNull: true,
      type: DataTypes.STRING,
      field: 'title',
    },
    description: {
      allowNull: true,
      type: DataTypes.STRING,
      field: 'description',
    },
    link: {
      allowNull: false,
      type: DataTypes.STRING,
      field: 'link',
    },
    challengeId: {
      allowNull: false,
      type: DataTypes.INTEGER,
      references: {
        model: 'challenges',
        key: 'id',
      },
      field: 'challenge_id',
    },
    width: {
      allowNull: true,
      type: DataTypes.INTEGER,
      field: 'width',
    },
    height: {
      allowNull: true,
      type: DataTypes.INTEGER,
      field: 'height',
    },
  }),
  down: queryInterface => queryInterface.dropTable('design_strategies'),
};
