module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_gifts', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id',
      },
      field: 'user_id',
    },
    giftId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'gifts',
        key: 'id',
      },
      field: 'gift_id',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_gifts'),
};
