module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('user_suscriptions', 'resubscribed_at', {
        allowNull: true,
        type: Sequelize.DATE,
        field: 'resubscribed_at',
      });
      await queryInterface.addColumn('user_suscriptions', 'cancelled_at', {
        allowNull: true,
        type: Sequelize.DATE,
        field: 'cancelled_at',
      });
      await queryInterface.addColumn('user_suscriptions', 'last_notification_received', {
        allowNull: true,
        type: Sequelize.STRING(50),
        field: 'last_notification_received',
      });
      await queryInterface.addColumn('user_suscriptions', 'purchase_token', {
        allowNull: true,
        type: Sequelize.STRING(255),
        field: 'purchase_token',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('user_suscriptions', 'resubscribed_at');
      await queryInterface.removeColumn('user_suscriptions', 'cancelled_at');
      await queryInterface.removeColumn('user_suscriptions', 'last_notification_received');
      await queryInterface.removeColumn('user_suscriptions', 'purchase_token');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
