module.exports = (sequelize, DataTypes) => {
  const AspectReinventationType = sequelize.define(
    'AspectReinventationType',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      info: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'info',
      },
      screenToNavigate: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'screen_to_navigate',
      },
      icon: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'icon',
      },
      blockingId: {
        allowNull: true,
        type: DataTypes.INTEGER,
        references: {
          model: 'aspects_reinventation_types',
          key: 'id',
        },
        field: 'blocking_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'aspects_reinventation_types',
    },
  );
  AspectReinventationType.associate = models => {
    AspectReinventationType.hasMany(models.AspectReinventation, {
      foreignKey: 'aspectReinventationTypeId',
      as: 'aspectReinventation',
    });
  };
  return AspectReinventationType;
};
