module.exports = (sequelize, DataTypes) => {
  const Challenge = sequelize.define(
    'Challenge',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      routeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'routes',
          key: 'id',
        },
        field: 'route_id',
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      info: {
        type: DataTypes.STRING(512),
        field: 'info',
      },
      link: {
        type: DataTypes.TEXT,
        field: 'link',
      },
      icon: {
        type: DataTypes.STRING,
        field: 'icon',
      },
      bitacoraLink: {
        type: DataTypes.TEXT,
        field: 'bitacora_link',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'challenges',
    },
  );
  Challenge.associate = models => {
    Challenge.belongsTo(models.Route, {
      foreignKey: 'routeId',
      as: 'route',
    });
    Challenge.belongsToMany(models.Strength, {
      through: 'ChallengeStrength',
      foreignKey: 'challengeId',
      as: 'strength',
      timestamps: false,
    });
    Challenge.belongsToMany(models.User, {
      through: 'UserChallenge',
      foreignKey: 'challengeId',
      as: 'userChallenges',
      timestamps: false,
    });
    Challenge.hasMany(models.AspectReinventation, {
      foreignKey: 'challengeId',
      as: 'aspectReinventation',
    });
    Challenge.hasMany(models.Habit, {
      foreignKey: 'challengeId',
      as: 'habit',
    });
    Challenge.hasMany(models.ActionPlan, {
      foreignKey: 'challengeId',
      as: 'actionPlan',
    });
    Challenge.hasMany(models.PowerfulQuestion, {
      foreignKey: 'challengeId',
      as: 'powerfulQuestion',
    });

    Challenge.hasMany(models.DesignStrategies, {
      foreignKey: 'challengeId',
      as: 'designStrategy',
    });
  };
  return Challenge;
};
