module.exports = (sequelize, DataTypes) => {
  const PromotionalCode = sequelize.define(
    'PromotionalCode',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      promCodeTypeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'promotional_codes',
          key: 'id',
        },
        field: 'promotional_code_type_id',
      },
      promotionalCode: {
        allowNull: false,
        type: DataTypes.STRING(20),
        field: 'promotionalcode',
      },
      validThru: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'validthru',
      },
      validFrom: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'validfrom',
      },
      validFor: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'validfor',
      },
      maxUses: {
        allowNull: false,
        type: DataTypes.INTEGER,
        field: 'maxusetimes',
      },
      scope: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'scope',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'promotional_codes',
    },
  );
  PromotionalCode.associate = models => {

    PromotionalCode.belongsTo(models.PromotionalType, {
      foreignKey: 'promCodeTypeId',
    });

    PromotionalCode.hasMany(models.PromotionalUsedCodes, {
      foreignKey: 'promCodeId',
    });

  };
  return PromotionalCode;
};
