module.exports = (sequelize, DataTypes) => {
  const RouteStrength = sequelize.define(
    'RouteStrength',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      routeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'routes',
          key: 'id',
        },
        field: 'route_id',
      },
      strengthId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'strengths',
          key: 'id',
        },
        field: 'strength_id',
      },
      pdfPath: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'pdf_path',
      },
      mobilePath: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'mobile_path',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'route_strength',
    },
  );
  RouteStrength.associate = (models) => {
    // UserSuscription.belongsTo(models.SuscriptionType, {
    //   foreignKey: 'suscriptionTypeId',
    // });
    // UserSuscription.belongsTo(models.User, {
    //   foreignKey: 'userId',
    // });
    RouteStrength.belongsTo(models.Route, {
      foreignKey: 'routeId',
      as: 'route',
    });
    RouteStrength.belongsTo(models.Strength, {
      foreignKey: 'strengthId',
      as: 'strength',
    });
  };
  return RouteStrength;
};
