module.exports = (sequelize, DataTypes) => {
  const SuscriptionType = sequelize.define(
    'SuscriptionType',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'suscription_types',
    },
  );
  SuscriptionType.associate = models => {
    SuscriptionType.belongsToMany(models.User, {
      through: 'UserSuscription',
      foreignKey: 'suscriptionTypeId',
      as: 'user',
      timestamps: true,
    });
    SuscriptionType.hasMany(models.Questionnarie, {
      foreignKey: 'suscriptionTypeId',
      as: 'questionnarie',
    });
    SuscriptionType.hasMany(models.User, {
      foreignKey: 'initialSuscriptionTypeId',
      as: 'initialSuscriptionTypeUser',
    });
  };
  return SuscriptionType;
};
