module.exports = (sequelize, DataTypes) => {
  const User = sequelize.define(
    'User',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      firstName: {
        type: DataTypes.STRING,
        field: 'first_name',
      },
      lastName: {
        type: DataTypes.STRING,
        field: 'last_name',
      },
      gender: {
        type: DataTypes.ENUM('F', 'M'),
        field: 'gender',
      },
      countryId: {
        type: DataTypes.INTEGER,
        references: {
          model: 'countries',
          key: 'id',
        },
        field: 'country_id',
      },
      educationalLevelId: {
        type: DataTypes.INTEGER,
        references: {
          model: 'educational_levels',
          key: 'id',
        },
        field: 'educational_level_id',
      },
      phone: {
        type: DataTypes.STRING,
        field: 'phone',
      },
      email: {
        type: DataTypes.STRING,
        field: 'email',
      },
      password: {
        type: DataTypes.TEXT,
        field: 'password',
      },
      city: {
        type: DataTypes.STRING,
        field: 'city',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
      confirmedEmail: {
        type: DataTypes.DATE,
        field: 'confirmed_email',
      },
      validationCodeEmail: {
        type: DataTypes.STRING(6),
        field: 'validation_code_email',
      },
      expirationCodeEmail: {
        type: DataTypes.DATE,
        field: 'expiration_code_email',
      },
      validationCodeResetPassword: {
        type: DataTypes.STRING(6),
        field: 'validation_code_reset_password',
      },
      expirationCodeResetPassword: {
        type: DataTypes.DATE,
        field: 'expiration_code_reset_password',
      },
      coachingReasonId: {
        type: DataTypes.INTEGER,
        references: {
          model: 'coaching_reasons',
          key: 'id',
        },
        field: 'coaching_reason_id',
      },
      initialSuscriptionTypeId: {
        type: DataTypes.INTEGER,
        references: {
          model: 'suscription_types',
          key: 'id',
        },
        field: 'initial_suscription_type_id',
      },
      profileImage: {
        type: DataTypes.TEXT('long'),
        field: 'profile_image',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'users',
    },
  );
  User.associate = models => {
    User.belongsTo(models.Country, { foreignKey: 'countryId', as: 'country' });
    User.belongsTo(models.EducationalLevel, {
      foreignKey: 'educationalLevelId',
      as: 'educationalLevel',
    });
    User.belongsToMany(models.Preference, {
      through: 'UserPreference',
      foreignKey: 'userId',
      as: 'preference',
      timestamps: false,
    });

    User.belongsToMany(models.SuscriptionType, {
      through: 'UserSuscription',
      foreignKey: 'userId',
      as: 'suscriptionType',
      timestamps: false,
    });

    User.hasMany(models.PromotionalUsedCodes, {
      foreignKey: 'userId',
      as: 'promotionalUsedCodes',
      timestamps: false,
    });

    User.belongsToMany(models.Route, {
      through: 'UserRoute',
      foreignKey: 'userId',
      as: 'routes',
      timestamps: false,
    });
    User.hasMany(models.Questionnarie, { foreignKey: 'userId', as: 'questionnaries' });
    User.hasMany(models.UserNotification, {
      foreignKey: 'userId',
      as: 'notifications',
    });
    User.belongsToMany(models.Challenge, {
      through: 'UserChallenge',
      foreignKey: 'userId',
      as: 'userChallenges',
      timestamps: false,
    });

    User.belongsToMany(models.Strength, {
      through: 'UserStrength',
      foreignKey: 'userId',
      as: 'strength',
      timestamps: false,
    });

    User.belongsTo(models.CoachingReason, {
      foreignKey: 'coachingReasonId',
      as: 'coachingReason',
    });

    User.belongsTo(models.SuscriptionType, {
      foreignKey: 'initialSuscriptionTypeId',
      as: 'initialSuscriptionType',
    });

    User.belongsToMany(models.AspectReinventation, {
      through: 'UserAspectReinventation',
      foreignKey: 'userId',
      as: 'userAspectReinventations',
      timestamps: false,
    });

    User.belongsToMany(models.Gift, {
      through: 'UserGift',
      foreignKey: 'userId',
      as: 'gifts',
      timestamps: false,
    });

    User.hasMany(models.UserDeviceToken, {
      foreignKey: 'userId',
      as: 'devices',
    });

    User.hasMany(models.UserSuscription, {
      foreignKey: 'userId',
      as: 'userSuscriptions'
    });
  };
  return User;
};
