const db = require('../database/models');
const serviceUtils = require('./utils.js');

const { DesignStrategies, UserAspectReinventation } = db;

exports.getDesignStategy = async userId => {
  try {
    const currentRoute = await serviceUtils.getCurrentUserRoute(userId);
    const { id: routeId = '' } = currentRoute;

    const currentChallenge = await serviceUtils.getCurrentUserChallenge(userId, routeId);
    const { id: challengeId = '' } = currentChallenge;

    const designStrategie = (await DesignStrategies.findOne({ where: { challengeId } })) || {};
    return {
      designStrategie,
      currentRoute,
      currentChallenge,
    };
  } catch (e) {
    throw e;
  }
};

exports.setActiveDesignStrategy = async userId => {
  try {
    const { id: routeId = '' } = await serviceUtils.getCurrentUserRoute(userId);

    const { id: challengeId = '' } = await serviceUtils.getCurrentUserChallenge(userId, routeId);

    const userAspectReinventationId = await serviceUtils.getCurrentUserAspectReinventation(
      userId,
      challengeId,
      2,
    );

    await UserAspectReinventation.update(
      { isActive: 1 },
      { where: { id: userAspectReinventationId } },
    );

    await serviceUtils.addToUserAspectReinventation(userId, challengeId, 2);
    return {};
  } catch (e) {
    throw e;
  }
};
