exports.texts = {
  routes: {
    emprender: {
      strengths: {
        creatividad: {
          description: [
            'Es la capacidad de idear con novedad, respuestas y soluciones frente a los retos o problemas.  Ser creativo implica enfocar la realidad con perspectivas originales que mezclan tendencias o aplican lógicas (conceptos y funcionamientos) de otros ambientes al ecosistema propio.',
            'Las personas creativas ven el mundo con curiosidad y hallan recursos donde otros no, tienden a ser libres para expresar sus pensamientos o sentimientos en diferentes formas, desde el arte, hasta los negocios.',
          ],
          listOne: [
            'Reta las ideas con las que te sientes cómodo para dar paso a nuevas formas de ver el mundo. Pregúntate ¿Existe otra solución? ¿Cuáles de mis creencias limitan mis ideas?',
            'Crea el hábito de conectar ideas, conocimientos o tendencias que aparentemente no se relacionan',
            'Enciende tus neuronas con nuevos aprendizajes en temas que no te has atrevido a explorar o que son un reto para la humanidad como la sostenibilidad, la longevidad, la inteligencia artificial, etc.',
            'Interactúa con el arte en sus múltiples formas, deja que sus mensajes y cánones influyan en tus ideas y en la forma en que haces las cosas',
            'Acércate o sigue a personas creativas, el arte de ser creativo es contagioso',
            'Tener conciencia de que para promover tus ideas creativas necesitas traducirlas en un lenguaje que tu entorno comprenda, ese lenguaje se soporta en paradigmas distintos',
          ],
          listTwo: [
            'Aplicas soluciones inadecuadas para problemas nuevos que requieren creatividad e innovación',
            'Haces siempre lo mismo creando rutinas aburridas, ineficientes, poco sostenibles',
            'Puedes terminar siendo excesivamente disruptivo, innecesariamente retador, extravagante creando incomprensión por parte las personas en quienes quieres influir',
            'Puedes hacerte prejuicioso',
          ],
        },
        relacionamiento: {
          description: [
            'Es la capacidad de relacionarse con las personas y los hechos de la vida con optimismo y apertura. Las personas extrovertidas conversan confiadamente con otras y compartes ideas con la expectativa de influir o simplemente intercambiar. Es la habilidad de interactuar con personas diversas y de aceptar paradigmas diferentes, la capacidad de probar cosas nuevas e incorporarlas al mundo propio.',
            'Las personas extrovertidas buscan a otros para nutrir su creatividad, aprecian diferentes formas de crear conocimiento, son curiosos y se aventuran a aprender y vivir en nuevas tendencias.',
          ],
          listOne: [
            'Crea el hábito de revisar tendencias en tu ámbito de conocimiento o en el de tu organización, date permiso para soñar y compartir los sueños',
            'Promueve en ti mismo el disfrute de la conversación desestructurada, sin agenda, incorporando temas o personas nuevas y diferentes',
            'Disminuye los juicios que haces de lo que no se parece a ti, comenzando por las situaciones más cercanas, conversando con personas nuevas, en lugares diferentes. La oferta de conferencias, charlas, foros es una gran oportunidad',
            'Acércate a lo creativo, al arte, el cine, la música o la literatura de otros países o de autores que no son los que ya tu cerebro acepta',
            'Supera el temor al otro, todas las personas tienen un interés o un tema que les apasiona ¡Descúbrelo!',
          ],
          listTwo: [
            'Pierdes de foco por dificultad para incorporar nuevos conocimientos diversidad a tu vida profesional.',
            'Puedes dejarte llevar por tendencias que no son adecuadas para las condiciones propias',
            'Terminas enganchado en discusiones poco productivas por desacuerdos que no valen la pena',
            'Crees que las relaciones hacen los éxitos… Aunque ciertamente los facilitan, se requieren propuestas o ideas de valor, influyentes, ordenadas, cuantificadas y bien sustentadas para que otros las compren',
            'Dedicas un tiempo excesivo al relacionamiento poco estratégico y la exploración',
            'Puedes caer en indiscreciones respecto a temas que no es conveniente compartir.',
            'Realizas de planes y promesas que no se concretan',
          ],
        },
        cooperacion: {
          description: [
            'Es la capacidad de construir con otros generando valor compartido a partir del aprovechamiento conjunto de recursos, oportunidades y conocimientos. Implica poder generar relaciones balanceadas en la que varios profesionales o departamentos persiguen un objetivo común.',
            'La cooperación permite detectar fortalezas complementarias que son requeridas para crear nuevas realidades, se trata de apoyar, ayudar, aportar, contribuir para que la acción de todos los involucrados acelere el alcance de objetivos de manera sostenible.',
          ],
          listOne: [
            'Fortalece la práctica de crear relaciones equilibradas y de largo plazo, cooperar no es solo recibir, o dar, implica crear reglas del juego y ser el primero en respetarlas.',
            'Construye confianza compartiendo información y resultados. Es importante apuntar que la confianza se crea con el tiempo, a través del cumplimiento de los compromisos, las conversaciones honestas y el conocimiento mutuo',
            'Practica el hábito de escuchar y respetar otras formas de pensar. Abre el debate de forma transparente exponiendo los desacuerdos para poder crear soluciones que tomen en cuenta la mayoría de las perspectivas.',
          ],
          listTwo: [
            'Pierdes tiempo en búsqueda de consensos absolutos, sin flexibilidad.',
            'Intentas procesos de cooperación sin reparar en las metodologías necesarias para llegar a acuerdos ',
            'No das cabida a la expresión individual o de las minorías',
            'Pierdes la capacidad de controlar proyectos en los que se requiere un líder con capacidad de articulación y coordinación de distintos equipos de trabajo',
            'Puedes perderte de ideas, soluciones, relaciones y recursos que otros puedan aportar, especialmente, puedes perder la confianza de otros',
          ],
        },
        innovacion: {
          description: [
            'Es la habilidad de idear soluciones novedosas, disruptivas y factibles orientadas a las necesidades del mercado. Esta fortaleza permite que se cuestionen los paradigmas previos y aporta la capacidad de convocar y articular inteligencia, conocimiento, recursos y entusiasmo en torno a la satisfacción de necesidades y resolución de problemas con eficiencia y rentabilidad.',
            'Esta fortaleza se puede ver afectada cuando se trabaja en ambientes que castigan el error, o donde los lideres temen al cambio; la innovación tiende a desaparecer en espacios laborales con exceso de restricciones y libertades, con un gobierno corporativo poco flexible y cerrado a las tendencias.',
          ],
          listOne: [
            'Identifica tendencias y mejora tu acceso a información actual procedente de diferentes mundos y fuentes.',
            'Activa tus prácticas tecnológicas y la integración de tus actividades al mundo digital.',
            'Hazte un experto en las características del mercado en el que quieres innovar, identifica sus aspiraciones y paradigmas dominantes.',
            'Conéctate con personas interesadas en tendencias, mentes diferentes que reten tus creencias, aprovecha sus inteligencias para robustecer tu pensamiento y crear soluciones más competitivas y originales.',
          ],
          listTwo: [
            'Puedes tener dificultades para aceptar y aprovechar lo nuevo.',
            'Te podrías olvidar de la importancia de la creatividad para hacer evolucionar tu vida.',
            'Podrías atascarte buscando la perfección dentro de un paradigma, sin notar que existen otros de mayor riqueza, potencial y oportunidad.',
          ],
        },
        pragmatismo: {
          description: [
            'Es la capacidad de interpretar la realidad a través de factores objetivos poniendo a un lado las emociones y pareceres imprecisos. El pragmatismo permite tomar de la realidad sus aspectos más verificables, compararlos y analizarlos para tomar decisiones frente a retos y dilemas de la vida y los negocios.',
            'Las personas pragmáticas son estructuradas, ordenadas y valoran la lógica; son analíticas y se sirven de datos e información fundamentada para convencer a otros y seleccionar alternativas, a la vez, dudan de las imprecisiones y las intuiciones.',
          ],
          listOne: [
            'Instala la práctica de buscar información que soporte tus planteamientos, ideas, hipótesis o suposiciones. Esto implica identificar fuentes de información confiable: colegas, artículos de expertos, conferencias, institutos de investigación, etc.',
            'Haz conciencia de tus emociones frente a una decisión y compleméntala con elementos, casos, hechos o datos que le aporten realismo a tus ideas, propuestas e iniciativas',
            'Registra hechos y datos en tus proyectos y procesos, esto proporciona estructura para revisar de manera más realista y objetiva las decisiones, y defender tus argumentos',
          ],
          listTwo: [
            'Crees que sólo los datos describen al mundo… Aunque ciertamente éstos ayudan a describir problemas y realidades, los datos fríos no conducen al éxito, requieren la interpretación de una mente que sueñe e intuya y un corazón que aporte pasión',
            'Tu comunicación es poco influyente por falta de conexión emocional',
            'Descalificas otras aproximaciones a la realidad que son más intuitivas, emotivas o creativas, te pierdes de su valor y cometes errores por interpretaciones incompletas',
            'Formulas ideas poco factibles o tiendes a hacer castillos en el aire, sin las fundaciones necesarias',
          ],
        },
        integridad: {
          description: [
            'Se refiere a la coherencia entre los valores que un líder postula y las acciones que realiza. Esa coherencia inspira a otros, produce credibilidad y reputación, aumenta tu influencia y es un factor clave para la gestión de recursos en una empresa.',
            'Es una gran ventaja tener la Integridad como fortaleza pues ser fiel a tus valores eleva tus probabilidades de tener una vida plena; aunque eventualmente te encuentres en situaciones difíciles donde debas defenderlos frente otros, siempre saldrás más fuerte al reafirmar tus convicciones.',
          ],
          listOne: [
            'Úsala como apoyo para liderar con el ejemplo a tu equipo de trabajo',
            'Aplica la perspectiva de sostenibilidad al manejo de recursos clave en tu empresa: conocimiento, personas, dinero, marca, infraestructura',
            'Incorpora valores a los proyectos y a las funciones de tu cargo en la organización',
            'Se responsable en tus actos, dejando de poner las causas de los fracasos fuera de ti',
            'No dejes que las crisis y falsos dilemas te den excusas para doblegar tus valores',
          ],
          listTwo: [
            'Pierdes la credibilidad en lo personal y profesional',
            'No capturas la oportunidad de ocupar un nuevo cargo o participar en un proyecto',
            'Decepcionas a tus aliados, familiares, colaboradores o socios, que observen tus inconsistencias',
            'Debilitas tu reputación y afectar tus relaciones profesionales y personales',
            'Eres etiquetado como una persona inconveniente',

          ],
        },
        creacionDeRedes: {
          description: [
            'Es la capacidad de relacionarse con personas del mundo profesional, en planos de confianza, con perspectivas de largo plazo. Se trata de una fortaleza que ha sido potenciada por las herramientas digitales y redes sociales, pero que va más allá, expresándose en la reputación y el posicionamiento de quien la posee.',
            'Las personas con la fortaleza “Creación de Redes” encuentran más fácilmente que otras, colaboradores para sus equipos, oportunidades de negocios, expertos o conocimientos de utilidad.',
          ],
          listOne: [
            'Dedica tiempo a conocer nuevas personas cuyos talentos, intereses o posiciones coincidan con tu ruta como persona o profesional',
            'Crea el hábito de registrar en la agenda de contactos a las personas que conoces para poder contactarlas posteriormente',
            'Identifica oportunidades profesionales para conectar con tus redes aportando invitaciones o información de valor',
            'Mantén contacto más allá de las oportunidades puntuales compartiendo de forma bilateral, conversaciones de interés',
          ],
          listTwo: [
            'Pierdes foco por exceso de tiempo dedicado al relacionamiento',
            'Crees que las redes sociales conducen al relacionamiento de calidad en forma automática. Para que el relacionamiento sea efectivo debe existir un valor que se intercambia, así como empatía, admiración o reconocimiento',
            'Equivocas el posicionamiento y debilitas la credibilidad por uso indebido de la red, por ejemplo, aprovechándola o desgastándola con intereses netamente individuales',
          ],
        },
        comunicacion: {
          description: [
            'Es la capacidad de transmitir información, exponer ideas o manifestar opiniones con lucidez y discernimiento. Esta fortaleza responde a la necesidad de guiar, influir y convencer. Es medular en los procesos de reinvención ya que acelera tus nuevos objetivos al facilitar el acceso a personas influyentes, recursos o apoyos. La comunicación te otorga la virtud de la buena conversación, es decir, te permite escuchar conocimientos, experiencias y oportunidades que otros te compartan.',
            'Esta fortaleza se puede ver afectada por tus propios temores, inseguridades o ansiedades. También por factores externos como información distorsionada en el ambiente de las redes sociales por lo que es valioso poner tus ideas en orden, contar con información veraz, conocer los intereses de tu interlocutor y escuchar sin interrumpir.',
          ],
          listOne: [
            'Conoce y segmenta tus audiencias e interlocutores, escuchar sus preocupaciones y dudas, saber sus expectativas',
            'Maneja el lenguaje general y específico en tu ambiente de negocios',
            'Aprende a leer el entorno, a contar con información actualizada y usarla para fortalecer tus argumentos',
            'Conócete y aprende sobre lo que ayuda y lo que deteriora tu comunicación. Crea un estilo propio',
            'Escribe bien, ten buena ortografía y calidad de redacción para ser comprendido por los demás (en redes, email o chat)',
            'Siempre, haz un espacio para escuchar y ser amable',
          ],
          listTwo: [
            'Creas mensajes importantes para ti, pero sin valor para los demás',
            'Dejas de influir en los demás, aunque tus mensajes sean relevantes',
            'Es posible que tus aliados, colegas y clientes no se sientan inspirados o convocados por tus ideas',
            'Puedes confundir influencia con manipulación creando ambientes de desconfianza y dañando la credibilidad que es el corazón del relacionamiento entre las personas',
            'Produces conversaciones poco diferenciadas o carentes de emoción, valor o empatía',
          ],
        },
        estrategiaYCambio: {
          description: ['Se refiere a la flexibilidad y la firmeza que se expresan frente a las transformaciones, las crisis e imprevistos en nuestra vida, emprendimientos y negocios. Esta fortaleza lleva en sí misma el aprendizaje humano de la evolución y es una ventaja competitiva cuando las circunstancias son adversas e impredecibles. Reconocer los cambios, poderlos intuir o anticipar con información de calidad y aprovechando la experiencia es una cualidad superior para la reinvención y el emprendimiento.',
            'La adaptación al cambio se ve afectada por creencias como: “Todo tiempo pasado fue mejor” o “¿Para qué cambiar, si todo funciona bien?”. Se suele relacionar el éxito y la felicidad con la estabilidad, sin considerar que la estabilidad es un equilibrio inestable. ¿Por qué no vincular el cambio con la energía vital y la innovación? El viaje de la reinvención se hace más cómodo y seguro si apelas a tus capacidades de adaptación, moviéndote al ritmo de los acontecimientos, manteniendo un propósito claro en tu mente y tu corazón.',
          ],
          listOne: [
            'Acepta el cambio como una señal de que estamos vivos. Sustituye el miedo por organización frente al cambio, infórmate, tu eliges cómo aprovecharlo, identifica cómo te afecta y mitiga los impactos. ¡Movilízate!',
            'Crea escenarios, imaginar qué variables de tu vida profesional o empresa podrían cambiar. Tal vez conviene más promover el cambio que enfrentarlo',
            'Celebra y abraza las transformaciones que se dan dentro de ti, cuando se presenta un cambio en tu vida, es un momento para conocerte más, usar fuerzas que desconocías y soñar nuevas situaciones',
            'Aporta tu inteligencia crítica como combustible de la reinvención, vas a necesitar retar creencias relacionadas con la aceptación de lo nuevo y lo diverso, con la estabilidad y las reglas que “siempre han sido así”',
            'Conócete a ti mismo, cuenta contigo, inspírate en lo que has aprendido, en tus logros, en los pasos que ya has superado',
            'Infórmate, escucha a expertos, colegas y amigos, analiza tus capacidades y se muy honesto contigo mismo para saber cuán rápido es tu ritmo de adaptación, es indispensable conocerte bien para adaptarte, emprender y reinventarte',
            'No olvides que a veces es necesaria la catarsis, deja fluir tus dilemas y emociones en un espacio seguro, donde encuentres comprensión y lealtad',
          ],
          listTwo: [
            'Iniciar los procesos de cambio con exceso de energía y agotarla antes de llegar a un nuevo punto de estabilidad',
            'Subestimar la transformación y no prepararte para eventuales cambios súbitos que te dejan sin respuestas',
            'Asumir el cambio o las crisis con pánico como emoción dominante y permanente, tomando decisiones precipitadas y excesivamente arriesgadas',
            'Confundir adaptación al cambio con persecución constante de riesgos, una cosa es estar listo para los cambios y promover transformaciones; otras es entrar en riesgos innecesarios sin propósitos de valor',
            'Ser irreflexivo frente a creencias o paradigmas y tomarse con poca seriedad el peso del pasado, es importante cuestionarse y ser crítico sin perder las anclas de tu personalidad.',

          ],
        },
        resiliencia: {
          description: [
            'Es la capacidad de superar la adversidad y responder a los imprevistos sin perder el rumbo, sin dejarse deteriorar. Es esa fuerza que te anima a poner la atención en un objetivo que se encuentra más allá de los obstáculos, que te moviliza a persistir, hacerte cargo y construir tus sueños sin que se erosionen la esperanza, la autoconfianza y los valores.',
            'La resiliencia tiene sus raíces en la física, definiéndose como la capacidad que tiene un cuerpo para regresar a su estado normal luego de haber resistido una presión. Se trata del poder para resistir con éxito los embates del medio ambiente y tener disposición, energía y claridad de propósito para enfrentar una mala realidad y tener logros a pesar de ella, e inclusive para aprovechar las oportunidades en esa realidad terrible.',
          ],
          listOne: [
            'Debes saber que alguna vez tocará transitar entornos difíciles y crecer en ellos sin resentimiento, con inteligencia y valores humanos como la generosidad y la esperanza',
            'Cultiva una red afectiva y profesional que colabore con tus objetivos',
            'Prepárate, desde lo pragmático hasta lo emocional, para los momentos de crisis, contando con las fortalezas que reconoces en ti mismo',
            'Ten la capacidad de decir “no” a lo que no deseas; desde el punto de vista del negocio implica poder renunciar a los pesos innecesarios y enfocar la acción en las ideas y estrategias que más oportunidades tienen de ser exitosas',
            'Encontrar el balance espiritual y ético para contener sentimientos que suelen aflorar cuando sufrimos embates, como la soberbia, la venganza, el resentimiento y la maldad',

          ],
          listTwo: [
            'Puedes experimentar un exceso de confianza en tus capacidades resilientes y entrar en entornos retadores y competitivos sin estar preparado como persona, profesional o emprendedor',
            'Puedes tener un espejismo de resiliencia y sufrir deterioro moral, ético o espiritual al superar las adversidades',
            'Tiendes a exponerte a la situación de adversidad por demasiado tiempo, guiado por la por tozudez y el ego, llevando al extremo las capacidades de subsistencia empresarial o personal',
            'Puedes justificar acciones fuera de la ética a partir de la adversidad',
          ],
        },
        trabajoEnEquipo: {
          description: [
            'Es la capacidad de integrar personas en torno a una idea, un proyecto, una promesa de valor o un objetivo. Trabajar en equipo requiere impulsar una visión conjunta y cooperar compartiendo información y cargas de trabajo, cumplir con la responsabilidad propia y colaborar o co-crear con los demás para que el resultado sea superior a la simple suma de las partes.',
            'Los miembros de un equipo revisan resultados con frecuencia, celebran éxitos y asumen responsabilidades cuando las cosas no van bien, siempre moviéndose hacia adelante, tomando los errores como aprendizajes.',
          ],
          listOne: [
            'Apalanca tu liderazgo en el equipo con tus fortalezas de cooperación, influencia e integridad. El reconocimiento del equipo depende de tu coherencia entre lo que postulas y lo que construyes con tus acciones',
            'Discute las diferencias con respeto, pero sin temor a estar en desacuerdo. Critica los procesos o las situaciones, mientras valoras a las personas',
            'Comparte la ruta prevista y reconoce los aportes y progresos que cada miembro del equipo va alcanzando',
            'Comparte la Visión y ejercita la previsión de obstáculos y oportunidades para estar siempre preparados',
            'Integra en tu agenda el hábito de conversar con tu equipo y compartir buenas prácticas',
            'Ten las puertas abiertas para escuchar y también para ofrecer ideas, conocimientos, buenas prácticas e información a tus compañeros',
            'Establece una forma de medición de avances que sea conocida y compartida, con indicadores individuales y de desempeño conjunto',
            'Practica la gratitud con tu equipo, comprendiendo la visión que cada uno aporta desde su particularidad como persona, profesional o líder',
          ],
          listTwo: [
            'El exceso de una visión colectiva puede opacar individualidades lo cual es inconveniente para generar incentivos individuales',
            'Puedes crear desbalance entre el tiempo que dedicas al equipo y el que dedicas al resto de la organización',
            'Tienes dificultad para identificar detractores del equipo, aquellas personas que no cooperan, pero aprovechan los logros colectivos',
            'Pierdes la confianza del equipo por opacidad o incomunicación en relación con los temas que conciernen a todos',
            'Dejas de promover la participación y la creatividad',
          ],
        },
        focoEnResultados: {
          description: [
            'Se trata de la capacidad de alcanzar logros con un ritmo firme y constante, superando los obstáculos que puedan surgir haciendo uso de todos los recursos disponibles.',
            'El foco en los resultados es una virtud conduce a distinguir las distracciones y ponerlas de lado, siguiendo una ruta clara y previendo los recursos para alcanzarla. Quienes cuentan con esta fortaleza, suelen valerse de herramientas de planeación y control que facilitan la revisión de avances, el seguimiento de metas y la identificación de atrasos u obstáculos que se puedan prever.',
          ],
          listOne: [
            'Mantén el objetivo en mente y busca los elementos y recursos que lo hagan factible',
            'Crea el hábito de planificar y familiarizarte con herramientas para registrar actividades, tiempos, recursos y responsabilidades',
            'Desarrolla disciplina y persistencia para el logro de los propósitos, e insistir hasta alcanzarlos',
            'Aprende a ser flexible cuando la ruta lo exige y así garantizar el resultado. Ser enfocado en resultados no implica golpearse contra la misma pared infinitamente',
            'Apóyate en la fortaleza de cooperación o comunicación para articular y alinear a los equipos de trabajo en torno a los objetivos de tu área',
          ],
          listTwo: [
            'Te estresas excesivamente por exigencias muy altas y, te frustras frecuentemente por incumplimiento de las metas',
            'Generas un ambiente de trabajo inflexible y hostil que solo reconoce avances cuantificables o hitos concretos',
            'Irrespetas los procesos, puedes perder calidad o pasar por encima de opiniones y normativas por alcanzar resultados',
            'Dejas pasar oportunidades alternativas por la incapacidad de cambiar de foco',
            'Puedes descalificar a personas con características creativas o colaborativas cuyos aportes a los resultados son más innovadores o flexibles',
          ],
        },
      },
    },
    crecer: {
      strengths: {
        creatividad: {
          description: [
            'Es la capacidad de idear con novedad, respuestas y soluciones frente a los retos o problemas.  Ser creativo implica enfocar la realidad con perspectivas originales que mezclan tendencias o aplican lógicas (conceptos y funcionamientos) de otros ambientes al ecosistema propio.',
            'Las personas creativas ven el mundo con curiosidad y hallan recursos donde otros no, tienden a ser libres para expresar sus pensamientos o sentimientos en diferentes formas, desde el arte, hasta los negocios.',
          ],
          listOne: [
            'Reta las ideas con las que te sientes cómodo para dar paso a nuevas formas de ver el mundo. Pregúntate ¿Existe otra solución? ¿Cuáles de mis creencias limitan mis ideas?',
            'Crea el hábito de conectar ideas, conocimientos o tendencias que aparentemente no se relacionan',
            'Enciende tus neuronas con nuevos aprendizajes en temas que no te has atrevido a explorar o que son un reto para la humanidad como la sostenibilidad, la longevidad, la inteligencia artificial, etc.',
            'Interactúa con el arte en sus múltiples formas, deja que sus mensajes y cánones influyan en tus ideas y en la forma en que haces las cosas',
            'Acércate o sigue a personas creativas, el arte de ser creativo es contagioso',
            'Tener conciencia de que para promover tus ideas creativas necesitas traducirlas en un lenguaje que tu entorno comprenda, ese lenguaje se soporta en paradigmas distintos',
          ],
          listTwo: [
            'Aplicas soluciones inadecuadas para problemas nuevos que requieren creatividad e innovación',
            'Haces siempre lo mismo creando rutinas aburridas, ineficientes, poco sostenibles',
            'Puedes terminar siendo excesivamente disruptivo, innecesariamente retador, extravagante creando incomprensión por parte las personas en quienes quieres influir',
            'Puedes hacerte prejuicioso',
          ],
        },
        relacionamiento: {
          description: [
            'Es la capacidad de relacionarse con las personas y los hechos de la vida con optimismo y apertura. Las personas extrovertidas conversan confiadamente con otras y compartes ideas con la expectativa de influir o simplemente intercambiar. Es la habilidad de interactuar con personas diversas y de aceptar paradigmas diferentes, la capacidad de probar cosas nuevas e incorporarlas al mundo propio.',
            'Las personas extrovertidas buscan a otros para nutrir su creatividad, aprecian diferentes formas de crear conocimiento, son curiosos y se aventuran a aprender y vivir en nuevas tendencias.',
          ],
          listOne: [
            'Crea el hábito de revisar tendencias en tu ámbito de conocimiento o en el de tu organización, date permiso para soñar y compartir los sueños',
            'Promueve en ti mismo el disfrute de la conversación desestructurada, sin agenda, incorporando temas o personas nuevas y diferentes',
            'Disminuye los juicios que haces de lo que no se parece a ti, comenzando por las situaciones más cercanas, conversando con personas nuevas, en lugares diferentes. La oferta de conferencias, charlas, foros es una gran oportunidad',
            'Acércate a lo creativo, al arte, el cine, la música o la literatura de otros países o de autores que no son los que ya tu cerebro acepta',
            'Supera el temor al otro, todas las personas tienen un interés o un tema que les apasiona ¡Descúbrelo!',
          ],
          listTwo: [
            'Pierdes de foco por dificultad para incorporar nuevos conocimientos diversidad a tu vida profesional.',
            'Puedes dejarte llevar por tendencias que no son adecuadas para las condiciones propias',
            'Terminas enganchado en discusiones poco productivas por desacuerdos que no valen la pena',
            'Crees que las relaciones hacen los éxitos… Aunque ciertamente los facilitan, se requieren propuestas o ideas de valor, influyentes, ordenadas, cuantificadas y bien sustentadas para que otros las compren',
            'Dedicas un tiempo excesivo al relacionamiento poco estratégico y la exploración',
            'Puedes caer en indiscreciones respecto a temas que no es conveniente compartir.',
            'Realizas de planes y promesas que no se concretan',
          ],
        },
        cooperacion: {
          description: [
            'Es la capacidad de construir con otros generando valor compartido a partir del aprovechamiento conjunto de recursos, oportunidades y conocimientos. Implica poder generar relaciones balanceadas en la que varios profesionales o departamentos persiguen un objetivo común.',
            'La cooperación permite detectar fortalezas complementarias que son requeridas para crear nuevas realidades, se trata de apoyar, ayudar, aportar, contribuir para que la acción de todos los involucrados acelere el alcance de objetivos de manera sostenible.',
          ],
          listOne: [
            'Fortalece la práctica de crear relaciones equilibradas y de largo plazo, cooperar no es solo recibir, o dar, implica crear reglas del juego y ser el primero en respetarlas.',
            'Construye confianza compartiendo información y resultados. Es importante apuntar que la confianza se crea con el tiempo, a través del cumplimiento de los compromisos, las conversaciones honestas y el conocimiento mutuo',
            'Practica el hábito de escuchar y respetar otras formas de pensar. Abre el debate de forma transparente exponiendo los desacuerdos para poder crear soluciones que tomen en cuenta la mayoría de las perspectivas.',
          ],
          listTwo: [
            'Pierdes tiempo en búsqueda de consensos absolutos, sin flexibilidad.',
            'Intentas procesos de cooperación sin reparar en las metodologías necesarias para llegar a acuerdos ',
            'No das cabida a la expresión individual o de las minorías',
            'Pierdes la capacidad de controlar proyectos en los que se requiere un líder con capacidad de articulación y coordinación de distintos equipos de trabajo',
            'Puedes perderte de ideas, soluciones, relaciones y recursos que otros puedan aportar, especialmente, puedes perder la confianza de otros',
          ],
        },
        innovacion: {
          description: [
            'Es la habilidad de idear soluciones novedosas, disruptivas y factibles orientadas a las necesidades del mercado. Esta fortaleza permite que se cuestionen los paradigmas previos y aporta la capacidad de convocar y articular inteligencia, conocimiento, recursos y entusiasmo en torno a la satisfacción de necesidades y resolución de problemas con eficiencia y rentabilidad.',
            'Esta fortaleza se puede ver afectada cuando se trabaja en ambientes que castigan el error, o donde los lideres temen al cambio; la innovación tiende a desaparecer en espacios laborales con exceso de restricciones y libertades, con un gobierno corporativo poco flexible y cerrado a las tendencias.',
          ],
          listOne: [
            'Identifica tendencias y mejora tu acceso a información actual procedente de diferentes mundos y fuentes.',
            'Activa tus prácticas tecnológicas y la integración de tus actividades al mundo digital.',
            'Hazte un experto en las características del mercado en el que quieres innovar, identifica sus aspiraciones y paradigmas dominantes.',
            'Conéctate con personas interesadas en tendencias, mentes diferentes que reten tus creencias, aprovecha sus inteligencias para robustecer tu pensamiento y crear soluciones más competitivas y originales.',
          ],
          listTwo: [
            'Puedes tener dificultades para aceptar y aprovechar lo nuevo.',
            'Te podrías olvidar de la importancia de la creatividad para hacer evolucionar tu vida.',
            'Podrías atascarte buscando la perfección dentro de un paradigma, sin notar que existen otros de mayor riqueza, potencial y oportunidad.',
          ],
        },
        pragmatismo: {
          description: [
            'Es la capacidad de interpretar la realidad a través de factores objetivos poniendo a un lado las emociones y pareceres imprecisos. El pragmatismo permite tomar de la realidad sus aspectos más verificables, compararlos y analizarlos para tomar decisiones frente a retos y dilemas de la vida y los negocios.',
            'Las personas pragmáticas son estructuradas, ordenadas y valoran la lógica; son analíticas y se sirven de datos e información fundamentada para convencer a otros y seleccionar alternativas, a la vez, dudan de las imprecisiones y las intuiciones.',
          ],
          listOne: [
            'Instala la práctica de buscar información que soporte tus planteamientos, ideas, hipótesis o suposiciones. Esto implica identificar fuentes de información confiable: colegas, artículos de expertos, conferencias, institutos de investigación, etc.',
            'Haz conciencia de tus emociones frente a una decisión y compleméntala con elementos, casos, hechos o datos que le aporten realismo a tus ideas, propuestas e iniciativas',
            'Registra hechos y datos en tus proyectos y procesos, esto proporciona estructura para revisar de manera más realista y objetiva las decisiones, y defender tus argumentos',
          ],
          listTwo: [
            'Crees que sólo los datos describen al mundo… Aunque ciertamente éstos ayudan a describir problemas y realidades, los datos fríos no conducen al éxito, requieren la interpretación de una mente que sueñe e intuya y un corazón que aporte pasión',
            'Tu comunicación es poco influyente por falta de conexión emocional',
            'Descalificas otras aproximaciones a la realidad que son más intuitivas, emotivas o creativas, te pierdes de su valor y cometes errores por interpretaciones incompletas',
            'Formulas ideas poco factibles o tiendes a hacer castillos en el aire, sin las fundaciones necesarias',
          ],
        },
        integridad: {
          description: [
            'Se refiere a la coherencia entre los valores que un líder postula y las acciones que realiza. Esa coherencia inspira a otros, produce credibilidad y reputación, aumenta tu influencia y es un factor clave para la gestión de recursos en una empresa.',
            'Es una gran ventaja tener la Integridad como fortaleza pues ser fiel a tus valores eleva tus probabilidades de tener una vida plena; aunque eventualmente te encuentres en situaciones difíciles donde debas defenderlos frente otros, siempre saldrás más fuerte al reafirmar tus convicciones.',
          ],
          listOne: [
            'Úsala como apoyo para liderar con el ejemplo a tu equipo de trabajo',
            'Aplica la perspectiva de sostenibilidad al manejo de recursos clave en tu empresa: conocimiento, personas, dinero, marca, infraestructura',
            'Incorpora valores a los proyectos y a las funciones de tu cargo en la organización',
            'Se responsable en tus actos, dejando de poner las causas de los fracasos fuera de ti',
            'No dejes que las crisis y falsos dilemas te den excusas para doblegar tus valores',
          ],
          listTwo: [
            'Pierdes la credibilidad en lo personal y profesional',
            'No capturas la oportunidad de ocupar un nuevo cargo o participar en un proyecto',
            'Decepcionas a tus aliados, familiares, colaboradores o socios, que observen tus inconsistencias',
            'Debilitas tu reputación y afectar tus relaciones profesionales y personales',
            'Eres etiquetado como una persona inconveniente',

          ],
        },
        creacionDeRedes: {
          description: [
            'Es la capacidad de relacionarse con personas del mundo profesional, en planos de confianza, con perspectivas de largo plazo. Se trata de una fortaleza que ha sido potenciada por las herramientas digitales y redes sociales, pero que va más allá, expresándose en la reputación y el posicionamiento de quien la posee.',
            'Las personas con la fortaleza “Creación de Redes” encuentran más fácilmente que otras, colaboradores para sus equipos, oportunidades de negocios, expertos o conocimientos de utilidad.',
          ],
          listOne: [
            'Dedica tiempo a conocer nuevas personas cuyos talentos, intereses o posiciones coincidan con tu ruta como persona o profesional',
            'Crea el hábito de registrar en la agenda de contactos a las personas que conoces para poder contactarlas posteriormente',
            'Identifica oportunidades profesionales para conectar con tus redes aportando invitaciones o información de valor',
            'Mantén contacto más allá de las oportunidades puntuales compartiendo de forma bilateral, conversaciones de interés',
          ],
          listTwo: [
            'Pierdes foco por exceso de tiempo dedicado al relacionamiento',
            'Crees que las redes sociales conducen al relacionamiento de calidad en forma automática. Para que el relacionamiento sea efectivo debe existir un valor que se intercambia, así como empatía, admiración o reconocimiento',
            'Equivocas el posicionamiento y debilitas la credibilidad por uso indebido de la red, por ejemplo, aprovechándola o desgastándola con intereses netamente individuales',
          ],
        },
        comunicacion: {
          description: [
            'Es la capacidad de transmitir información, exponer ideas o manifestar opiniones con lucidez y discernimiento. Esta fortaleza responde a la necesidad de guiar, influir y convencer. Es medular en los procesos de reinvención ya que acelera tus nuevos objetivos al facilitar el acceso a personas influyentes, recursos o apoyos. La comunicación te otorga la virtud de la buena conversación, es decir, te permite escuchar conocimientos, experiencias y oportunidades que otros te compartan.',
            'Esta fortaleza se puede ver afectada por tus propios temores, inseguridades o ansiedades. También por factores externos como información distorsionada en el ambiente de las redes sociales por lo que es valioso poner tus ideas en orden, contar con información veraz, conocer los intereses de tu interlocutor y escuchar sin interrumpir.',
          ],
          listOne: [
            'Conoce y segmenta tus audiencias e interlocutores, escuchar sus preocupaciones y dudas, saber sus expectativas',
            'Maneja el lenguaje general y específico en tu ambiente de negocios',
            'Aprende a leer el entorno, a contar con información actualizada y usarla para fortalecer tus argumentos',
            'Conócete y aprende sobre lo que ayuda y lo que deteriora tu comunicación. Crea un estilo propio',
            'Escribe bien, ten buena ortografía y calidad de redacción para ser comprendido por los demás (en redes, email o chat)',
            'Siempre, haz un espacio para escuchar y ser amable',
          ],
          listTwo: [
            'Creas mensajes importantes para ti, pero sin valor para los demás',
            'Dejas de influir en los demás, aunque tus mensajes sean relevantes',
            'Es posible que tus aliados, colegas y clientes no se sientan inspirados o convocados por tus ideas',
            'Puedes confundir influencia con manipulación creando ambientes de desconfianza y dañando la credibilidad que es el corazón del relacionamiento entre las personas',
            'Produces conversaciones poco diferenciadas o carentes de emoción, valor o empatía',
          ],
        },
        estrategiaYCambio: {
          description: ['Se refiere a la flexibilidad y la firmeza que se expresan frente a las transformaciones, las crisis e imprevistos en nuestra vida, emprendimientos y negocios. Esta fortaleza lleva en sí misma el aprendizaje humano de la evolución y es una ventaja competitiva cuando las circunstancias son adversas e impredecibles. Reconocer los cambios, poderlos intuir o anticipar con información de calidad y aprovechando la experiencia es una cualidad superior para la reinvención y el emprendimiento.',
            'La adaptación al cambio se ve afectada por creencias como: “Todo tiempo pasado fue mejor” o “¿Para qué cambiar, si todo funciona bien?”. Se suele relacionar el éxito y la felicidad con la estabilidad, sin considerar que la estabilidad es un equilibrio inestable. ¿Por qué no vincular el cambio con la energía vital y la innovación? El viaje de la reinvención se hace más cómodo y seguro si apelas a tus capacidades de adaptación, moviéndote al ritmo de los acontecimientos, manteniendo un propósito claro en tu mente y tu corazón.',
          ],
          listOne: [
            'Acepta el cambio como una señal de que estamos vivos. Sustituye el miedo por organización frente al cambio, infórmate, tu eliges cómo aprovecharlo, identifica cómo te afecta y mitiga los impactos. ¡Movilízate!',
            'Crea escenarios, imaginar qué variables de tu vida profesional o empresa podrían cambiar. Tal vez conviene más promover el cambio que enfrentarlo',
            'Celebra y abraza las transformaciones que se dan dentro de ti, cuando se presenta un cambio en tu vida, es un momento para conocerte más, usar fuerzas que desconocías y soñar nuevas situaciones',
            'Aporta tu inteligencia crítica como combustible de la reinvención, vas a necesitar retar creencias relacionadas con la aceptación de lo nuevo y lo diverso, con la estabilidad y las reglas que “siempre han sido así”',
            'Conócete a ti mismo, cuenta contigo, inspírate en lo que has aprendido, en tus logros, en los pasos que ya has superado',
            'Infórmate, escucha a expertos, colegas y amigos, analiza tus capacidades y se muy honesto contigo mismo para saber cuán rápido es tu ritmo de adaptación, es indispensable conocerte bien para adaptarte, emprender y reinventarte',
            'No olvides que a veces es necesaria la catarsis, deja fluir tus dilemas y emociones en un espacio seguro, donde encuentres comprensión y lealtad',
          ],
          listTwo: [
            'Iniciar los procesos de cambio con exceso de energía y agotarla antes de llegar a un nuevo punto de estabilidad',
            'Subestimar la transformación y no prepararte para eventuales cambios súbitos que te dejan sin respuestas',
            'Asumir el cambio o las crisis con pánico como emoción dominante y permanente, tomando decisiones precipitadas y excesivamente arriesgadas',
            'Confundir adaptación al cambio con persecución constante de riesgos, una cosa es estar listo para los cambios y promover transformaciones; otras es entrar en riesgos innecesarios sin propósitos de valor',
            'Ser irreflexivo frente a creencias o paradigmas y tomarse con poca seriedad el peso del pasado, es importante cuestionarse y ser crítico sin perder las anclas de tu personalidad.',

          ],
        },
        resiliencia: {
          description: [
            'Es la capacidad de superar la adversidad y responder a los imprevistos sin perder el rumbo, sin dejarse deteriorar. Es esa fuerza que te anima a poner la atención en un objetivo que se encuentra más allá de los obstáculos, que te moviliza a persistir, hacerte cargo y construir tus sueños sin que se erosionen la esperanza, la autoconfianza y los valores.',
            'La resiliencia tiene sus raíces en la física, definiéndose como la capacidad que tiene un cuerpo para regresar a su estado normal luego de haber resistido una presión. Se trata del poder para resistir con éxito los embates del medio ambiente y tener disposición, energía y claridad de propósito para enfrentar una mala realidad y tener logros a pesar de ella, e inclusive para aprovechar las oportunidades en esa realidad terrible.',
          ],
          listOne: [
            'Debes saber que alguna vez tocará transitar entornos difíciles y crecer en ellos sin resentimiento, con inteligencia y valores humanos como la generosidad y la esperanza',
            'Cultiva una red afectiva y profesional que colabore con tus objetivos',
            'Prepárate, desde lo pragmático hasta lo emocional, para los momentos de crisis, contando con las fortalezas que reconoces en ti mismo',
            'Ten la capacidad de decir “no” a lo que no deseas; desde el punto de vista del negocio implica poder renunciar a los pesos innecesarios y enfocar la acción en las ideas y estrategias que más oportunidades tienen de ser exitosas',
            'Encontrar el balance espiritual y ético para contener sentimientos que suelen aflorar cuando sufrimos embates, como la soberbia, la venganza, el resentimiento y la maldad',

          ],
          listTwo: [
            'Puedes experimentar un exceso de confianza en tus capacidades resilientes y entrar en entornos retadores y competitivos sin estar preparado como persona, profesional o emprendedor',
            'Puedes tener un espejismo de resiliencia y sufrir deterioro moral, ético o espiritual al superar las adversidades',
            'Tiendes a exponerte a la situación de adversidad por demasiado tiempo, guiado por la por tozudez y el ego, llevando al extremo las capacidades de subsistencia empresarial o personal',
            'Puedes justificar acciones fuera de la ética a partir de la adversidad',
          ],
        },
        trabajoEnEquipo: {
          description: [
            'Es la capacidad de integrar personas en torno a una idea, un proyecto, una promesa de valor o un objetivo. Trabajar en equipo requiere impulsar una visión conjunta y cooperar compartiendo información y cargas de trabajo, cumplir con la responsabilidad propia y colaborar o co-crear con los demás para que el resultado sea superior a la simple suma de las partes.',
            'Los miembros de un equipo revisan resultados con frecuencia, celebran éxitos y asumen responsabilidades cuando las cosas no van bien, siempre moviéndose hacia adelante, tomando los errores como aprendizajes.',
          ],
          listOne: [
            'Apalanca tu liderazgo en el equipo con tus fortalezas de cooperación, influencia e integridad. El reconocimiento del equipo depende de tu coherencia entre lo que postulas y lo que construyes con tus acciones',
            'Discute las diferencias con respeto, pero sin temor a estar en desacuerdo. Critica los procesos o las situaciones, mientras valoras a las personas',
            'Comparte la ruta prevista y reconoce los aportes y progresos que cada miembro del equipo va alcanzando',
            'Comparte la Visión y ejercita la previsión de obstáculos y oportunidades para estar siempre preparados',
            'Integra en tu agenda el hábito de conversar con tu equipo y compartir buenas prácticas',
            'Ten las puertas abiertas para escuchar y también para ofrecer ideas, conocimientos, buenas prácticas e información a tus compañeros',
            'Establece una forma de medición de avances que sea conocida y compartida, con indicadores individuales y de desempeño conjunto',
            'Practica la gratitud con tu equipo, comprendiendo la visión que cada uno aporta desde su particularidad como persona, profesional o líder',
          ],
          listTwo: [
            'El exceso de una visión colectiva puede opacar individualidades lo cual es inconveniente para generar incentivos individuales',
            'Puedes crear desbalance entre el tiempo que dedicas al equipo y el que dedicas al resto de la organización',
            'Tienes dificultad para identificar detractores del equipo, aquellas personas que no cooperan, pero aprovechan los logros colectivos',
            'Pierdes la confianza del equipo por opacidad o incomunicación en relación con los temas que conciernen a todos',
            'Dejas de promover la participación y la creatividad',
          ],
        },
        focoEnResultados: {
          description: [
            'Se trata de la capacidad de alcanzar logros con un ritmo firme y constante, superando los obstáculos que puedan surgir haciendo uso de todos los recursos disponibles.',
            'El foco en los resultados es una virtud conduce a distinguir las distracciones y ponerlas de lado, siguiendo una ruta clara y previendo los recursos para alcanzarla. Quienes cuentan con esta fortaleza, suelen valerse de herramientas de planeación y control que facilitan la revisión de avances, el seguimiento de metas y la identificación de atrasos u obstáculos que se puedan prever.',
          ],
          listOne: [
            'Mantén el objetivo en mente y busca los elementos y recursos que lo hagan factible',
            'Crea el hábito de planificar y familiarizarte con herramientas para registrar actividades, tiempos, recursos y responsabilidades',
            'Desarrolla disciplina y persistencia para el logro de los propósitos, e insistir hasta alcanzarlos',
            'Aprende a ser flexible cuando la ruta lo exige y así garantizar el resultado. Ser enfocado en resultados no implica golpearse contra la misma pared infinitamente',
            'Apóyate en la fortaleza de cooperación o comunicación para articular y alinear a los equipos de trabajo en torno a los objetivos de tu área',
          ],
          listTwo: [
            'Te estresas excesivamente por exigencias muy altas y, te frustras frecuentemente por incumplimiento de las metas',
            'Generas un ambiente de trabajo inflexible y hostil que solo reconoce avances cuantificables o hitos concretos',
            'Irrespetas los procesos, puedes perder calidad o pasar por encima de opiniones y normativas por alcanzar resultados',
            'Dejas pasar oportunidades alternativas por la incapacidad de cambiar de foco',
            'Puedes descalificar a personas con características creativas o colaborativas cuyos aportes a los resultados son más innovadores o flexibles',
          ],
        },
      },
    },
    crear: {
      strengths: {
        creatividad: {
          description: [
            'Es la capacidad de idear con novedad, respuestas y soluciones frente a los retos o problemas.  Ser creativo implica enfocar la realidad con perspectivas originales que mezclan tendencias o aplican lógicas (conceptos y funcionamientos) de otros ambientes al ecosistema propio.',
            'Las personas creativas ven el mundo con curiosidad y hallan recursos donde otros no, tienden a ser libres para expresar sus pensamientos o sentimientos en diferentes formas, desde el arte, hasta los negocios.',
          ],
          listOne: [
            'Reta las ideas con las que te sientes cómodo para dar paso a nuevas formas de ver el mundo. Pregúntate ¿Existe otra solución? ¿Cuáles de mis creencias limitan mis ideas?',
            'Crea el hábito de conectar ideas, conocimientos o tendencias que aparentemente no se relacionan',
            'Enciende tus neuronas con nuevos aprendizajes en temas que no te has atrevido a explorar o que son un reto para la humanidad como la sostenibilidad, la longevidad, la inteligencia artificial, etc.',
            'Interactúa con el arte en sus múltiples formas, deja que sus mensajes y cánones influyan en tus ideas y en la forma en que haces las cosas',
            'Acércate o sigue a personas creativas, el arte de ser creativo es contagioso',
            'Tener conciencia de que para promover tus ideas creativas necesitas traducirlas en un lenguaje que tu entorno comprenda, ese lenguaje se soporta en paradigmas distintos',
          ],
          listTwo: [
            'Aplicas soluciones inadecuadas para problemas nuevos que requieren creatividad e innovación',
            'Haces siempre lo mismo creando rutinas aburridas, ineficientes, poco sostenibles',
            'Puedes terminar siendo excesivamente disruptivo, innecesariamente retador, extravagante creando incomprensión por parte las personas en quienes quieres influir',
            'Puedes hacerte prejuicioso',
          ],
        },
        relacionamiento: {
          description: [
            'Es la capacidad de relacionarse con las personas y los hechos de la vida con optimismo y apertura. Las personas extrovertidas conversan confiadamente con otras y compartes ideas con la expectativa de influir o simplemente intercambiar. Es la habilidad de interactuar con personas diversas y de aceptar paradigmas diferentes, la capacidad de probar cosas nuevas e incorporarlas al mundo propio.',
            'Las personas extrovertidas buscan a otros para nutrir su creatividad, aprecian diferentes formas de crear conocimiento, son curiosos y se aventuran a aprender y vivir en nuevas tendencias.',
          ],
          listOne: [
            'Crea el hábito de revisar tendencias en tu ámbito de conocimiento o en el de tu organización, date permiso para soñar y compartir los sueños',
            'Promueve en ti mismo el disfrute de la conversación desestructurada, sin agenda, incorporando temas o personas nuevas y diferentes',
            'Disminuye los juicios que haces de lo que no se parece a ti, comenzando por las situaciones más cercanas, conversando con personas nuevas, en lugares diferentes. La oferta de conferencias, charlas, foros es una gran oportunidad',
            'Acércate a lo creativo, al arte, el cine, la música o la literatura de otros países o de autores que no son los que ya tu cerebro acepta',
            'Supera el temor al otro, todas las personas tienen un interés o un tema que les apasiona ¡Descúbrelo!',
          ],
          listTwo: [
            'Pierdes de foco por dificultad para incorporar nuevos conocimientos diversidad a tu vida profesional.',
            'Puedes dejarte llevar por tendencias que no son adecuadas para las condiciones propias',
            'Terminas enganchado en discusiones poco productivas por desacuerdos que no valen la pena',
            'Crees que las relaciones hacen los éxitos… Aunque ciertamente los facilitan, se requieren propuestas o ideas de valor, influyentes, ordenadas, cuantificadas y bien sustentadas para que otros las compren',
            'Dedicas un tiempo excesivo al relacionamiento poco estratégico y la exploración',
            'Puedes caer en indiscreciones respecto a temas que no es conveniente compartir.',
            'Realizas de planes y promesas que no se concretan',
          ],
        },
        cooperacion: {
          description: [
            'Es la capacidad de construir con otros generando valor compartido a partir del aprovechamiento conjunto de recursos, oportunidades y conocimientos. Implica poder generar relaciones balanceadas en la que varios profesionales o departamentos persiguen un objetivo común.',
            'La cooperación permite detectar fortalezas complementarias que son requeridas para crear nuevas realidades, se trata de apoyar, ayudar, aportar, contribuir para que la acción de todos los involucrados acelere el alcance de objetivos de manera sostenible.',
          ],
          listOne: [
            'Fortalece la práctica de crear relaciones equilibradas y de largo plazo, cooperar no es solo recibir, o dar, implica crear reglas del juego y ser el primero en respetarlas.',
            'Construye confianza compartiendo información y resultados. Es importante apuntar que la confianza se crea con el tiempo, a través del cumplimiento de los compromisos, las conversaciones honestas y el conocimiento mutuo',
            'Practica el hábito de escuchar y respetar otras formas de pensar. Abre el debate de forma transparente exponiendo los desacuerdos para poder crear soluciones que tomen en cuenta la mayoría de las perspectivas.',
          ],
          listTwo: [
            'Pierdes tiempo en búsqueda de consensos absolutos, sin flexibilidad.',
            'Intentas procesos de cooperación sin reparar en las metodologías necesarias para llegar a acuerdos ',
            'No das cabida a la expresión individual o de las minorías',
            'Pierdes la capacidad de controlar proyectos en los que se requiere un líder con capacidad de articulación y coordinación de distintos equipos de trabajo',
            'Puedes perderte de ideas, soluciones, relaciones y recursos que otros puedan aportar, especialmente, puedes perder la confianza de otros',
          ],
        },
        innovacion: {
          description: [
            'Es la habilidad de idear soluciones novedosas, disruptivas y factibles orientadas a las necesidades del mercado. Esta fortaleza permite que se cuestionen los paradigmas previos y aporta la capacidad de convocar y articular inteligencia, conocimiento, recursos y entusiasmo en torno a la satisfacción de necesidades y resolución de problemas con eficiencia y rentabilidad.',
            'Esta fortaleza se puede ver afectada cuando se trabaja en ambientes que castigan el error, o donde los lideres temen al cambio; la innovación tiende a desaparecer en espacios laborales con exceso de restricciones y libertades, con un gobierno corporativo poco flexible y cerrado a las tendencias.',
          ],
          listOne: [
            'Identifica tendencias y mejora tu acceso a información actual procedente de diferentes mundos y fuentes.',
            'Activa tus prácticas tecnológicas y la integración de tus actividades al mundo digital.',
            'Hazte un experto en las características del mercado en el que quieres innovar, identifica sus aspiraciones y paradigmas dominantes.',
            'Conéctate con personas interesadas en tendencias, mentes diferentes que reten tus creencias, aprovecha sus inteligencias para robustecer tu pensamiento y crear soluciones más competitivas y originales.',
          ],
          listTwo: [
            'Puedes tener dificultades para aceptar y aprovechar lo nuevo.',
            'Te podrías olvidar de la importancia de la creatividad para hacer evolucionar tu vida.',
            'Podrías atascarte buscando la perfección dentro de un paradigma, sin notar que existen otros de mayor riqueza, potencial y oportunidad.',
          ],
        },
        pragmatismo: {
          description: [
            'Es la capacidad de interpretar la realidad a través de factores objetivos poniendo a un lado las emociones y pareceres imprecisos. El pragmatismo permite tomar de la realidad sus aspectos más verificables, compararlos y analizarlos para tomar decisiones frente a retos y dilemas de la vida y los negocios.',
            'Las personas pragmáticas son estructuradas, ordenadas y valoran la lógica; son analíticas y se sirven de datos e información fundamentada para convencer a otros y seleccionar alternativas, a la vez, dudan de las imprecisiones y las intuiciones.',
          ],
          listOne: [
            'Instala la práctica de buscar información que soporte tus planteamientos, ideas, hipótesis o suposiciones. Esto implica identificar fuentes de información confiable: colegas, artículos de expertos, conferencias, institutos de investigación, etc.',
            'Haz conciencia de tus emociones frente a una decisión y compleméntala con elementos, casos, hechos o datos que le aporten realismo a tus ideas, propuestas e iniciativas',
            'Registra hechos y datos en tus proyectos y procesos, esto proporciona estructura para revisar de manera más realista y objetiva las decisiones, y defender tus argumentos',
          ],
          listTwo: [
            'Crees que sólo los datos describen al mundo… Aunque ciertamente éstos ayudan a describir problemas y realidades, los datos fríos no conducen al éxito, requieren la interpretación de una mente que sueñe e intuya y un corazón que aporte pasión',
            'Tu comunicación es poco influyente por falta de conexión emocional',
            'Descalificas otras aproximaciones a la realidad que son más intuitivas, emotivas o creativas, te pierdes de su valor y cometes errores por interpretaciones incompletas',
            'Formulas ideas poco factibles o tiendes a hacer castillos en el aire, sin las fundaciones necesarias',
          ],
        },
        integridad: {
          description: [
            'Se refiere a la coherencia entre los valores que un líder postula y las acciones que realiza. Esa coherencia inspira a otros, produce credibilidad y reputación, aumenta tu influencia y es un factor clave para la gestión de recursos en una empresa.',
            'Es una gran ventaja tener la Integridad como fortaleza pues ser fiel a tus valores eleva tus probabilidades de tener una vida plena; aunque eventualmente te encuentres en situaciones difíciles donde debas defenderlos frente otros, siempre saldrás más fuerte al reafirmar tus convicciones.',
          ],
          listOne: [
            'Úsala como apoyo para liderar con el ejemplo a tu equipo de trabajo',
            'Aplica la perspectiva de sostenibilidad al manejo de recursos clave en tu empresa: conocimiento, personas, dinero, marca, infraestructura',
            'Incorpora valores a los proyectos y a las funciones de tu cargo en la organización',
            'Se responsable en tus actos, dejando de poner las causas de los fracasos fuera de ti',
            'No dejes que las crisis y falsos dilemas te den excusas para doblegar tus valores',
          ],
          listTwo: [
            'Pierdes la credibilidad en lo personal y profesional',
            'No capturas la oportunidad de ocupar un nuevo cargo o participar en un proyecto',
            'Decepcionas a tus aliados, familiares, colaboradores o socios, que observen tus inconsistencias',
            'Debilitas tu reputación y afectar tus relaciones profesionales y personales',
            'Eres etiquetado como una persona inconveniente',

          ],
        },
        creacionDeRedes: {
          description: [
            'Es la capacidad de relacionarse con personas del mundo profesional, en planos de confianza, con perspectivas de largo plazo. Se trata de una fortaleza que ha sido potenciada por las herramientas digitales y redes sociales, pero que va más allá, expresándose en la reputación y el posicionamiento de quien la posee.',
            'Las personas con la fortaleza “Creación de Redes” encuentran más fácilmente que otras, colaboradores para sus equipos, oportunidades de negocios, expertos o conocimientos de utilidad.',
          ],
          listOne: [
            'Dedica tiempo a conocer nuevas personas cuyos talentos, intereses o posiciones coincidan con tu ruta como persona o profesional',
            'Crea el hábito de registrar en la agenda de contactos a las personas que conoces para poder contactarlas posteriormente',
            'Identifica oportunidades profesionales para conectar con tus redes aportando invitaciones o información de valor',
            'Mantén contacto más allá de las oportunidades puntuales compartiendo de forma bilateral, conversaciones de interés',
          ],
          listTwo: [
            'Pierdes foco por exceso de tiempo dedicado al relacionamiento',
            'Crees que las redes sociales conducen al relacionamiento de calidad en forma automática. Para que el relacionamiento sea efectivo debe existir un valor que se intercambia, así como empatía, admiración o reconocimiento',
            'Equivocas el posicionamiento y debilitas la credibilidad por uso indebido de la red, por ejemplo, aprovechándola o desgastándola con intereses netamente individuales',
          ],
        },
        comunicacion: {
          description: [
            'Es la capacidad de transmitir información, exponer ideas o manifestar opiniones con lucidez y discernimiento. Esta fortaleza responde a la necesidad de guiar, influir y convencer. Es medular en los procesos de reinvención ya que acelera tus nuevos objetivos al facilitar el acceso a personas influyentes, recursos o apoyos. La comunicación te otorga la virtud de la buena conversación, es decir, te permite escuchar conocimientos, experiencias y oportunidades que otros te compartan.',
            'Esta fortaleza se puede ver afectada por tus propios temores, inseguridades o ansiedades. También por factores externos como información distorsionada en el ambiente de las redes sociales por lo que es valioso poner tus ideas en orden, contar con información veraz, conocer los intereses de tu interlocutor y escuchar sin interrumpir.',
          ],
          listOne: [
            'Conoce y segmenta tus audiencias e interlocutores, escuchar sus preocupaciones y dudas, saber sus expectativas',
            'Maneja el lenguaje general y específico en tu ambiente de negocios',
            'Aprende a leer el entorno, a contar con información actualizada y usarla para fortalecer tus argumentos',
            'Conócete y aprende sobre lo que ayuda y lo que deteriora tu comunicación. Crea un estilo propio',
            'Escribe bien, ten buena ortografía y calidad de redacción para ser comprendido por los demás (en redes, email o chat)',
            'Siempre, haz un espacio para escuchar y ser amable',
          ],
          listTwo: [
            'Creas mensajes importantes para ti, pero sin valor para los demás',
            'Dejas de influir en los demás, aunque tus mensajes sean relevantes',
            'Es posible que tus aliados, colegas y clientes no se sientan inspirados o convocados por tus ideas',
            'Puedes confundir influencia con manipulación creando ambientes de desconfianza y dañando la credibilidad que es el corazón del relacionamiento entre las personas',
            'Produces conversaciones poco diferenciadas o carentes de emoción, valor o empatía',
          ],
        },
        estrategiaYCambio: {
          description: ['Se refiere a la flexibilidad y la firmeza que se expresan frente a las transformaciones, las crisis e imprevistos en nuestra vida, emprendimientos y negocios. Esta fortaleza lleva en sí misma el aprendizaje humano de la evolución y es una ventaja competitiva cuando las circunstancias son adversas e impredecibles. Reconocer los cambios, poderlos intuir o anticipar con información de calidad y aprovechando la experiencia es una cualidad superior para la reinvención y el emprendimiento.',
            'La adaptación al cambio se ve afectada por creencias como: “Todo tiempo pasado fue mejor” o “¿Para qué cambiar, si todo funciona bien?”. Se suele relacionar el éxito y la felicidad con la estabilidad, sin considerar que la estabilidad es un equilibrio inestable. ¿Por qué no vincular el cambio con la energía vital y la innovación? El viaje de la reinvención se hace más cómodo y seguro si apelas a tus capacidades de adaptación, moviéndote al ritmo de los acontecimientos, manteniendo un propósito claro en tu mente y tu corazón.',
          ],
          listOne: [
            'Acepta el cambio como una señal de que estamos vivos. Sustituye el miedo por organización frente al cambio, infórmate, tu eliges cómo aprovecharlo, identifica cómo te afecta y mitiga los impactos. ¡Movilízate!',
            'Crea escenarios, imaginar qué variables de tu vida profesional o empresa podrían cambiar. Tal vez conviene más promover el cambio que enfrentarlo',
            'Celebra y abraza las transformaciones que se dan dentro de ti, cuando se presenta un cambio en tu vida, es un momento para conocerte más, usar fuerzas que desconocías y soñar nuevas situaciones',
            'Aporta tu inteligencia crítica como combustible de la reinvención, vas a necesitar retar creencias relacionadas con la aceptación de lo nuevo y lo diverso, con la estabilidad y las reglas que “siempre han sido así”',
            'Conócete a ti mismo, cuenta contigo, inspírate en lo que has aprendido, en tus logros, en los pasos que ya has superado',
            'Infórmate, escucha a expertos, colegas y amigos, analiza tus capacidades y se muy honesto contigo mismo para saber cuán rápido es tu ritmo de adaptación, es indispensable conocerte bien para adaptarte, emprender y reinventarte',
            'No olvides que a veces es necesaria la catarsis, deja fluir tus dilemas y emociones en un espacio seguro, donde encuentres comprensión y lealtad',
          ],
          listTwo: [
            'Iniciar los procesos de cambio con exceso de energía y agotarla antes de llegar a un nuevo punto de estabilidad',
            'Subestimar la transformación y no prepararte para eventuales cambios súbitos que te dejan sin respuestas',
            'Asumir el cambio o las crisis con pánico como emoción dominante y permanente, tomando decisiones precipitadas y excesivamente arriesgadas',
            'Confundir adaptación al cambio con persecución constante de riesgos, una cosa es estar listo para los cambios y promover transformaciones; otras es entrar en riesgos innecesarios sin propósitos de valor',
            'Ser irreflexivo frente a creencias o paradigmas y tomarse con poca seriedad el peso del pasado, es importante cuestionarse y ser crítico sin perder las anclas de tu personalidad.',

          ],
        },
        resiliencia: {
          description: [
            'Es la capacidad de superar la adversidad y responder a los imprevistos sin perder el rumbo, sin dejarse deteriorar. Es esa fuerza que te anima a poner la atención en un objetivo que se encuentra más allá de los obstáculos, que te moviliza a persistir, hacerte cargo y construir tus sueños sin que se erosionen la esperanza, la autoconfianza y los valores.',
            'La resiliencia tiene sus raíces en la física, definiéndose como la capacidad que tiene un cuerpo para regresar a su estado normal luego de haber resistido una presión. Se trata del poder para resistir con éxito los embates del medio ambiente y tener disposición, energía y claridad de propósito para enfrentar una mala realidad y tener logros a pesar de ella, e inclusive para aprovechar las oportunidades en esa realidad terrible.',
          ],
          listOne: [
            'Debes saber que alguna vez tocará transitar entornos difíciles y crecer en ellos sin resentimiento, con inteligencia y valores humanos como la generosidad y la esperanza',
            'Cultiva una red afectiva y profesional que colabore con tus objetivos',
            'Prepárate, desde lo pragmático hasta lo emocional, para los momentos de crisis, contando con las fortalezas que reconoces en ti mismo',
            'Ten la capacidad de decir “no” a lo que no deseas; desde el punto de vista del negocio implica poder renunciar a los pesos innecesarios y enfocar la acción en las ideas y estrategias que más oportunidades tienen de ser exitosas',
            'Encontrar el balance espiritual y ético para contener sentimientos que suelen aflorar cuando sufrimos embates, como la soberbia, la venganza, el resentimiento y la maldad',

          ],
          listTwo: [
            'Puedes experimentar un exceso de confianza en tus capacidades resilientes y entrar en entornos retadores y competitivos sin estar preparado como persona, profesional o emprendedor',
            'Puedes tener un espejismo de resiliencia y sufrir deterioro moral, ético o espiritual al superar las adversidades',
            'Tiendes a exponerte a la situación de adversidad por demasiado tiempo, guiado por la por tozudez y el ego, llevando al extremo las capacidades de subsistencia empresarial o personal',
            'Puedes justificar acciones fuera de la ética a partir de la adversidad',
          ],
        },
        trabajoEnEquipo: {
          description: [
            'Es la capacidad de integrar personas en torno a una idea, un proyecto, una promesa de valor o un objetivo. Trabajar en equipo requiere impulsar una visión conjunta y cooperar compartiendo información y cargas de trabajo, cumplir con la responsabilidad propia y colaborar o co-crear con los demás para que el resultado sea superior a la simple suma de las partes.',
            'Los miembros de un equipo revisan resultados con frecuencia, celebran éxitos y asumen responsabilidades cuando las cosas no van bien, siempre moviéndose hacia adelante, tomando los errores como aprendizajes.',
          ],
          listOne: [
            'Apalanca tu liderazgo en el equipo con tus fortalezas de cooperación, influencia e integridad. El reconocimiento del equipo depende de tu coherencia entre lo que postulas y lo que construyes con tus acciones',
            'Discute las diferencias con respeto, pero sin temor a estar en desacuerdo. Critica los procesos o las situaciones, mientras valoras a las personas',
            'Comparte la ruta prevista y reconoce los aportes y progresos que cada miembro del equipo va alcanzando',
            'Comparte la Visión y ejercita la previsión de obstáculos y oportunidades para estar siempre preparados',
            'Integra en tu agenda el hábito de conversar con tu equipo y compartir buenas prácticas',
            'Ten las puertas abiertas para escuchar y también para ofrecer ideas, conocimientos, buenas prácticas e información a tus compañeros',
            'Establece una forma de medición de avances que sea conocida y compartida, con indicadores individuales y de desempeño conjunto',
            'Practica la gratitud con tu equipo, comprendiendo la visión que cada uno aporta desde su particularidad como persona, profesional o líder',
          ],
          listTwo: [
            'El exceso de una visión colectiva puede opacar individualidades lo cual es inconveniente para generar incentivos individuales',
            'Puedes crear desbalance entre el tiempo que dedicas al equipo y el que dedicas al resto de la organización',
            'Tienes dificultad para identificar detractores del equipo, aquellas personas que no cooperan, pero aprovechan los logros colectivos',
            'Pierdes la confianza del equipo por opacidad o incomunicación en relación con los temas que conciernen a todos',
            'Dejas de promover la participación y la creatividad',
          ],
        },
        focoEnResultados: {
          description: [
            'Se trata de la capacidad de alcanzar logros con un ritmo firme y constante, superando los obstáculos que puedan surgir haciendo uso de todos los recursos disponibles.',
            'El foco en los resultados es una virtud conduce a distinguir las distracciones y ponerlas de lado, siguiendo una ruta clara y previendo los recursos para alcanzarla. Quienes cuentan con esta fortaleza, suelen valerse de herramientas de planeación y control que facilitan la revisión de avances, el seguimiento de metas y la identificación de atrasos u obstáculos que se puedan prever.',
          ],
          listOne: [
            'Mantén el objetivo en mente y busca los elementos y recursos que lo hagan factible',
            'Crea el hábito de planificar y familiarizarte con herramientas para registrar actividades, tiempos, recursos y responsabilidades',
            'Desarrolla disciplina y persistencia para el logro de los propósitos, e insistir hasta alcanzarlos',
            'Aprende a ser flexible cuando la ruta lo exige y así garantizar el resultado. Ser enfocado en resultados no implica golpearse contra la misma pared infinitamente',
            'Apóyate en la fortaleza de cooperación o comunicación para articular y alinear a los equipos de trabajo en torno a los objetivos de tu área',
          ],
          listTwo: [
            'Te estresas excesivamente por exigencias muy altas y, te frustras frecuentemente por incumplimiento de las metas',
            'Generas un ambiente de trabajo inflexible y hostil que solo reconoce avances cuantificables o hitos concretos',
            'Irrespetas los procesos, puedes perder calidad o pasar por encima de opiniones y normativas por alcanzar resultados',
            'Dejas pasar oportunidades alternativas por la incapacidad de cambiar de foco',
            'Puedes descalificar a personas con características creativas o colaborativas cuyos aportes a los resultados son más innovadores o flexibles',
          ],
        },
      },
    },
  },
};
