exports.ERRORS = {
  ERROR_INTERNO: {
    httpCode: 500,
    code: '#9999',
    message: 'Ha ocurrido un error interno, intente mas tarde.',
  },
  NO_ENCONTRADO: {
    httpCode: 404,
    code: '#1000',
    message: 'El recurso no existe o no tiene privilegios para acceder.',
  },
  FALTAN_CAMPOS_REQUERIDOS: {
    httpCode: 400,
    code: '#1001',
    message: 'Faltan campos que son obligatorios.',
  },
  USUARIO_NO_EXISTE: {
    httpCode: 404,
    code: '#1002',
    message: 'El usuario no existe en nuestros registros.',
  },
  CREDENCIALES_INCORRECTAS: {
    httpCode: 401,
    code: '#1003',
    message: 'Usuario y/o contraseña inválida.',
  },
  TOKEN_INVALIDO: {
    httpCode: 401,
    code: '#1004',
    message: 'Ha ocurrido un error de autenticación, inicie sesión de nuevo.',
  },
  USUARIO_NO_AUTORIZADO: {
    httpCode: 401,
    code: '#1005',
    message: 'Necesitas privilegios para accederlo.',
  },
  EL_USUARIO_NO_TIENE_ACCESO_AL_SISTEMA: {
    httpCode: 401,
    code: '#1006',
    message: 'Este usuario no tiene acceso al sistema.',
  },
  CORREO_EXISTENTE: {
    httpCode: 401,
    code: '#1007',
    message: 'Este correo ya se encuentra registrado en el sistema.',
  },
  CONTRASENAS_INCORRECTAS: {
    httpCode: 401,
    code: '#1008',
    message: 'Las contraseñas no coinciden.',
  },
  CODIGO_DE_VALIDACION_DE_CORREO_INCORRECTO: {
    httpCode: 401,
    code: '#1009',
    message: 'El código de validación no coincide con el correo ingresado.',
  },
  CODIGO_DE_VALIDACION_EXPIRADO: {
    httpCode: 401,
    code: '#1010',
    message: 'El código de validación ingresado expiró.',
  },
  CORREO_NO_EXISTE: {
    httpCode: 404,
    code: '#1011',
    message: 'Este correo no se encuentra registrado en el sistema.',
  },
  CODIGO_DE_VALIDACION_DE_RESETEO_PASSWORD_INCORRECTO: {
    httpCode: 401,
    code: '#1012',
    message:
      'El código de validación para reseteo de contraseña no coincide con el correo ingresado.',
  },
  CODIGO_DE_VALIDACION_RESETEO_PASSWORD_EXPIRADO: {
    httpCode: 401,
    code: '#1013',
    message: 'El código de validación para reseteo de contraseña ingresado expiró.',
  },
  USUARIO_SIN_RUTA: {
    httpCode: 401,
    code: '#1014',
    message: 'El usuario no posee una ruta activa.',
  },
  RUTA_EXISTENTE: {
    httpCode: 401,
    code: '#1015',
    message: 'El usuario ya posee activa esta ruta.',
  },
  CUESTIONARIO_EXISTENTE: {
    httpCode: 401,
    code: '#1016',
    message: 'El usuario ya posee un cuestionario con la suscripcion ingresada.',
  },
  TIEMPO_EDICION_EXPIRO: {
    httpCode: 401,
    code: '#1017',
    message: 'El tiempo de edición de las respuestas del cuestionario culminó.',
  },
  CUESTIONARIO_INEXISTENTE: {
    httpCode: 401,
    code: '#1018',
    message: 'El usuario no posee una cuestionario para la suscripcion especificada.',
  },
  FECHA_INICIO_INVALIDA: {
    httpCode: 401,
    code: '#1019',
    message: 'La fecha de inicio debe ser mayor o igual al día actual.',
  },
  FECHA_FIN_INVALIDA: {
    httpCode: 401,
    code: '#1020',
    message: 'La fecha fin debe ser mayor a la fecha de inicio. Puedes programar acciones en un lapso de 365 días.',
  },
  PLAN_ACCION_INICIADO: {
    httpCode: 401,
    code: '#1020',
    message: 'La fecha de inicio del plan de accion ya inicio.',
  },
  CONTRASENAS_ACTUAL_INVALIDA: {
    httpCode: 401,
    code: '#1021',
    message: 'La contraseñas actual no coincide.',
  },
  TRANSACTION_ID_YA_ASOCIADO: {
    httpCode: 401,
    code: '#1022',
    message: 'Esta cuenta ya posee una trasacción asociada a la suscripción requerida.',
  },
  USUARIO_NO_POSEE_PLAN_COACHING_ACTIVO: {
    httpCode: 403,
    code: '#1023',
    message: 'Suscripción se encuentra inactiva. Para mayor información, puedes contactarnos vía contacto@becrack.com',
  },
  PROMOTIONAL_CODE_INVALIDO: {
    httpCode: 401,
    code: '#1024',
    message: 'El código promocional no es válido o ya no se encuentra disponible, por favor intente con otro código.',
  },
};
exports.DEFAULT_ERROR = {
  httpCode: 500,
  code: '#9999',
  message: 'Ha ocurrido un error inesperado, intente mas tarde.',
};

// Time between cron jobs to send notifications in seconds
exports.TIME_BETWEEN_CRON = 300;
