exports.texts = {
  routes: {
    emprender: {
      strengths: {
        creatividad: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Creatividad”', bold: true },
              ' como la capacidad de idear con novedad, respuestas y soluciones frente a los retos o problemas.  Ser creativo implica enfocar la realidad con perspectivas originales que mezclan tendencias o aplican lógicas de otros ambientes al ecosistema propio.',
              '\n\n',
              'Las personas creativas ven el mundo con curiosidad y ven recursos donde otros no, y tienden a ser libres para expresar sus pensamientos o sentimientos en diferentes formas, desde el arte, hasta los negocios.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Retar las ideas con las que te sientes cómodo para dar paso a nuevas formas de ver el mundo. Preguntarte ¿Qué otra forma hay para resolver esto? ¿Cuál es la otra solución adecuada?',
              'Crear el hábito de conectar ideas, conocimientos o tendencias que aparentemente no se relacionan',
              'Encender tus neuronas con nuevos aprendizajes en temas que no te has atrevido a explorar o que son un reto para la humanidad como la sostenibilidad, la longevidad, la inteligencia artificial, etc.',
              'Interactuar con el arte en sus múltiples formas y dejar que los mensajes, emociones o parámetros influyan en tus ideas y la forma en que haces las cosas',
              'Acercarte o seguir a personas creativas, el arte de ser creativo es contagioso, si te dejas influir',
              'Tener conciencia de que para promover tus ideas necesitas traducirlas en un lenguaje que tu entorno comprenda',
            ],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Aplicar soluciones inadecuadas para problemas nuevos que requieren creatividad e innovación',
              'Hacer siempre lo mismo creando rutinas aburridas, ineficientes, no sostenibles',
              'Ser excesivamente disruptivo, innecesariamente retador, extravagante creando incomprensión o prejuicios por parte las personas en quienes quieres influir',
              'Crear soluciones avanzadas para tu tiempo, que requieren un cambio de paradigma previo',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        relacionamiento: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Extroversión”', bold: true },
              ' como la capacidad de relacionarse con las personas y los hechos de la vida con optimismo y apertura. Las personas extrovertidas conversan confiadamente con otras y compartes ideas con la expectativa de influir o simplemente intercambiar. Es la habilidad de interactuar con personas diversas y de aceptar paradigmas diferentes, la capacidad de probar cosas nuevas e incorporarlas al mundo propio.',
              '\n\n',
              'Las personas extrovertidas buscan a otros para nutrir su creatividad, aprecian diferentes formas de crear conocimiento, son curiosos y se aventuran a aprender y vivir en nuevas tendencias.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Crear el hábito de revisar tendencias en tu ámbito de conocimiento o en tu emprendimiento. Darte permiso para soñar y compartir los sueños',
              'Promover en ti mismo el disfrute de la conversación desestructurada, sin agenda, incorporando temas o personas nuevas y diferentes',
              'Disminuir los juicios que haces de lo que no se parece a ti, comenzando por las situaciones más cercanas, conversando con personas nuevas, en lugares diferentes. La oferta de conferencias, charlas, foros es una gran oportunidad',
              'Acercarte a lo creativo, al arte, el cine, la música o la literatura de otros países o de autores que no son los que ya tu cerebro acepta',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Pérdida de foco por dificultad para incorporar a la vida o al emprendimiento los nuevos conocimientos y lo diverso. Dejarse llevar por tendencias que no son adecuadas para las condiciones propias',
              'Engancharse en discusiones poco productivas por desacuerdo con nuevas tendencias',
              'Creer que las relaciones hacen los éxitos. Aunque ciertamente los facilitan, se requieren propuestas o ideas de valor, influyentes y bien sustentadas para que otros las compren',
              'Exceso de tiempo invertido en relacionamiento y exploración',
              'Pérdida de discreción respecto a temas que no es conveniente compartir. Exceso de planes y promesas que no se concretan',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        cooperacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Cooperación”', bold: true },
              ' como la capacidad de construir con otros generando valor compartido a partir del aprovechamiento conjunto de recursos, oportunidades y conocimientos. Implica poder generar relaciones balanceadas en la que varias personas o emprendimientos persiguen un objetivo común.',
              '\n\n',
              'La cooperación permite detectar fortalezas complementarias que son requeridas para crear nuevas realidades, se trata de apoyar, ayudar, aportar, contribuir con la confianza de que la acción de todos los involucrados es necesaria para transformar la realidad.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Fortalecer la práctica de crear relaciones equilibradas y de largo plazo, cooperar no es solo recibir, o dar, implica crear reglas del juego y ser el primero en respetarlas.',
              'Construir confianza compartiendo información y resultados. Es importante apuntar que la confianza se crea con el tiempo, a través del cumplimiento de los compromisos y el conocimiento mutuo.',
              'Practicar el hábito de escuchar y respetar otras formas de pensar. Abrir el debate de forma transparente exponiendo los desacuerdos para poder crear soluciones que tomen en cuenta la mayoría de las perspectivas.',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Ralentización por búsqueda de consensos absolutos. Intentar procesos complejos de cooperación sin metodologías para llegar a acuerdos',
              'No dar cabida a la expresión individual o aplastar a las minorías cuando se requiere tomar decisiones',
              'Descontrol de los proyectos o confusión respecto al objetivo por ausencia de liderazgos adecuados. La cooperación, además de ser una competencia para construir en equipo, es un reto para los líderes',
              'Pérdida de las ideas, soluciones, relaciones y recursos que otros pueden aportar. Especialmente, pérdida de su confianza',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        innovacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Innovación”', bold: true },
              ' como la habilidad de idear soluciones novedosas, disruptivas y factibles orientadas a las necesidades del mercado. Esta fortaleza permite que se cuestionen los paradigmas previos y aporta la capacidad de convocar y articular inteligencia, conocimiento, recursos y entusiasmo en torno a la satisfacción de necesidades y resolución de problemas con eficiencia y rentabilidad.',
              '\n\n',
              'Esta fortaleza se puede ver afectada cuando se trabaja en ambientes que castigan el error, o donde los lideres temen al cambio; la innovación tiende a desaparecer en espacios laborales con exceso de restricciones y libertades, con un gobierno corporativo poco flexible y cerrado a las tendencias.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Identifica tendencias y mejora tu acceso a información actual procedente de diferentes mundos y fuentes.',
              'Activa tus prácticas tecnológicas y la integración de tus actividades al mundo digital.',
              'Hazte un experto en las características del mercado en el que quieres innovar, identifica sus aspiraciones y paradigmas dominantes.',
              'Conéctate con personas interesadas en tendencias, mentes diferentes que reten tus creencias, aprovecha sus inteligencias para robustecer tu pensamiento y crear soluciones más competitivas y originales.',
            ],
            // margin: [20, 0, 0, 0]
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Puedes tener dificultades para aceptar y aprovechar lo nuevo.',
              'Te podrías olvidar de la importancia de la creatividad para hacer evolucionar tu vida.',
              'Podrías atascarte buscando la perfección dentro de un paradigma, sin notar que existen otros de mayor riqueza, potencial y oportunidad.',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        pragmatismo: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Pragmatismo”', bold: true },
              ' como la capacidad de interpretar la realidad a través de factores objetivos poniendo a un lado las emociones y pareceres imprecisos. El pragmatismo permite tomar de la realidad sus aspectos más verificables, compararlos y analizarlos para tomar decisiones frente a retos y dilemas de la vida y los negocios.',
              '\n\n',
              'Las personas pragmáticas son estructuradas, ordenadas y valoran la lógica; son analíticas y se sirven de datos e información fundamentada para convencer a otros y seleccionar alternativas, a la vez, dudan de las imprecisiones y las intuiciones.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Instalar la práctica de buscar información que soporte tus planteamientos, ideas, hipótesis o suposiciones. Esto implica identificar fuentes de información confiable: colegas, artículos de expertos, conferencias, institutos de investigación, etc.',
              'Hacer conciencia de tus emociones frente a una decisión y complementarla con elementos, casos, hechos o datos que le aporten realismo a tus ideas, propuestas e iniciativas',
              'Registrar hechos y datos de tus actividades, especialmente las relacionadas con tu proceso de reinvención. Esto proporciona estructura para revisar de manera más realista y objetiva las decisiones y los efectos en tu negocio',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Creer que sólo los datos describen al mundo. Aunque ciertamente éstos ayudan a describir problemas y realidades, los datos fríos no conducen al éxito, requieren la interpretación de una mente que sueñe e intuya y un corazón que aporte pasión',
              'Comunicación poco influyente con los demás: tu familia, colaboradores, jefes, amigos, aliados o equipos de trabajo, por falta de conexión emocional',
              'Descalificar otras aproximaciones a la realidad, más intuitivas, emotivas o creativas, perdiendo su valor y cometiendo errores',
              'Formular ideas poco factibles o hacer castillos en el aire, si las fundaciones necesarias',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        integridad: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Integridad”', bold: true },
              ' como la coherencia entre los valores que un líder postulan y las acciones que realiza. Esa coherencia inspira a otros, produce credibilidad y reputación, y aumenta la influencia. Es una gran ventaja tener la Integridad como fortaleza pues una de sus expresiones es la transparencia en la relación con los demás y en el manejo de recursos lo que crea confianza en tu entorno.',
              '\n\n',
              'Ser fiel a tus valores eleva tus probabilidades de tener una vida plena; aunque eventualmente te encuentres en situaciones difíciles donde debas defenderlos frente al estatus quo o frente al poder, siempre saldrás más fuerte al reafirmar tus convicciones.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Usarla como apoyo para liderar con el ejemplo',
              'Aplicar valores positivos en las ideas, los proyectos y emprendimientos',
              'Incorporar la perspectiva de la responsabilidad en tus actos, dejando de poner las causas de los fracasos fuera de ti',
              'Incluir valores de sostenibilidad en lo que haces, desde hacer crecer a tu familia, hasta emprender',
              'No dejar que las crisis y falsos dilemas te den excusas para doblegar tus valores',
              'prueba de texto',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Perder la credibilidad en lo personal y profesional',
              'Decepcionar a tus aliados, familiares, colaboradores o socios, que observen tus inconsistencias',
              'Debilitar tu reputación y afectar tus relaciones profesionales y personales',
              'Ser etiquetado junto a personas inconvenientes',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        creacionDeRedes: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Creación de redes”', bold: true },
              ' como la capacidad de relacionarse con personas del mundo profesional, en planos de confianza, con perspectivas de largo plazo. Se trata de una competencia que ha sido potenciada por las herramientas digitales y redes sociales, pero que va más allá, expresándose en la reputación y el posicionamiento de quien la posee.',
              '\n\n',
              'Las personas con la competencia “Creación de Redes” encuentran más fácilmente que otras, colaboradores para sus equipos, oportunidades de negocios, expertos o conocimientos de utilidad.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Dedicar tiempo a conocer nuevas personas cuyos talentos, intereses o posiciones coincidan con tu ruta como persona, emprendedor o profesional',
              'Crear el hábito de registrar en la agenda de contactos a las personas que conoces para poder contactarlas posteriormente',
              'Identificar oportunidades profesionales para conectar con tus redes aportando invitaciones o información de valor',
              'Mantener contacto más allá de las oportunidades puntuales compartiendo de forma bilateral, conversaciones de interés',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Pérdida de foco por exceso de tiempo dedicado al relacionamiento',
              'Creer que las redes sociales conducen al relacionamiento de calidad en forma automática. Para que el relacionamiento sea efectivo debe existir un valor que se intercambia',
              'Equivocar el posicionamiento y debilitar la credibilidad por uso indebido de la red, por ejemplo, aprovechándola o desgastándola con intereses netamente individuales',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        comunicacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Comunicación”', bold: true },
              ' como la capacidad de transmitir información, exponer ideas o manifestar opiniones con lucidez y discernimiento. Esta fortaleza responde a la necesidad de guiar, influir y convencer. Esta fortaleza es medular en los procesos de reinvención ya que: acelera tus nuevos objetivos al facilitar el acceso a recursos o apoyos, y también te otorga la virtud de la buena conversación, es decir, te permite escuchar conocimientos, experiencias y oportunidades que otros te compartan.',
              '\n\n',
              'Esta fortaleza se puede ver afectada por tus propios temores, inseguridades o ansiedades. También por factores externos como información distorsionada en el ambiente de las redes sociales por lo que es valioso poner tus ideas en orden, contar con información veraz, conocer los intereses de tu interlocutor y escuchar sin interrumpir.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Conocer tus audiencias e interlocutores, escuchar sus preocupaciones y dudas, saber sus expectativas',
              'Manejar el lenguaje general y específico en tu ambiente de negocios',
              'Leer el entorno, contar con información actualizada',
              'Conocerte, saber lo que ayuda y lo que deteriora tu comunicación',
              'Escribir bien, tener buena ortografía y calidad de redacción para ser comprendido por los lectores',
              'Siempre, haz un espacio para escuchar y ser amable',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Crear mensajes importantes para ti, pero sin valor para los demás',
              'Crear mensajes relevantes, pero transmitirlos sin influir en los demás',
              'Aburrir a otros que pueden ser aliados, socios y clientes que no se sientan inspirados o convocados por tus ideas',
              'Confundir influencia con manipulación creando ambientes de desconfianza y dañando la credibilidad que es el corazón del relacionamiento entre las personas',
              'Producir mensajes poco diferenciados o carentes de emoción, inspiración o empatía',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        estrategiaYCambio: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Adaptación al Cambio”', bold: true },
              ' como la flexibilidad y la firmeza que se expresan frente a las transformaciones, las crisis e imprevistos en nuestra vida, emprendimientos y negocios. Esta fortaleza lleva en sí misma el aprendizaje humano de la evolución y es una ventaja competitiva cuando las circunstancias son adversas e impredecibles. Reconocer los cambios, poderlos intuir o anticipar con información de calidad y aprovechando la experiencia es una cualidad superior para la reinvención y el emprendimiento.',
              '\n\n',
              'Esta fortaleza se puede ver afectada por creencias que dificultan el cambio como: “Todo tiempo pasado fue mejor” o “¿Para qué cambiar, si todo funciona bien?”. Ha características culturales que relacionan el éxito y la felicidad con la estabilidad, sin considerar que la estabilidad es un equilibrio inestable. El viaje de la reinvención se hace más cómodo y seguro si apelas a tus capacidades de adaptación, moviéndote al ritmo de los acontecimientos, manteniendo un propósito claro en tu mente y tu corazón.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'No temer a los cambios, aceptarlos como una señal de que estamos vivos. Sustituye el miedo por organización frente al cambio, infórmate, tu eliges cómo aprovecharlo, identifica cómo te afecta y mitiga los impactos. Movilízate',
              'Crear escenarios, imaginar qué variables de tu vida o empresa podrían cambiar. Tal vez conviene más promover el cambio que enfrentarlo',
              'Celebrar y abrazar las transformaciones que se dan dentro de ti, cuando se presenta un cambio en tu vida, es un momento para conocerte más, usar fuerzas que desconocías y soñar nuevas situaciones',
              'Aportar tu inteligencia crítica como combustible de la reinvención, vas a necesitar retar creencias relacionadas con la aceptación de lo nuevo y lo diverso, con la estabilidad y las reglas que “siempre han sido así”',
              'Informarte, escuchar expertos, colegas y amigos, analizar tus capacidades y ser muy honesto contigo mismo para saber cuán rápido es tu ritmo de adaptación, es indispensable conocerte bien para adaptarte, emprender y reinventarte',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Iniciar los procesos de cambio con exceso de energía y agotarla antes de llegar a un nuevo punto de estabilidad',
              'Subestimar la transformación y no prepararte para eventuales cambios súbitos que te dejan sin respuestas',
              'Asumir el cambio o las crisis con pánico como emoción dominante y permanente, tomando decisiones precipitadas y excesivamente arriesgadas',
              'Confundir adaptación al cambio con persecución constante de riesgos, una cosa es estar listo para los cambios y promover transformaciones; otras es entrar en riesgos innecesarios sin propósitos de valor',
              'Ser irreflexivo frente a creencias o paradigmas y tomarse con poca seriedad el peso del pasado, es importante cuestionarse y ser crítico sin perder las anclas de tu personalidad.',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        resiliencia: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Resiliencia”', bold: true },
              ' como la capacidad de superar la adversidad y responder a los imprevistos sin perder el rumbo, ni dejarse deteriorar. Es esa fuerza que te anima a poner la atención en un objetivo que se encuentra más allá de los obstáculos, que te moviliza a seguir luchando y ocupándote de alcanzar tus sueños sin que se erosionen la esperanza, la autoconfianza y los valores.',
              '\n\n',
              'La resiliencia tiene sus raíces en la física, definiéndose como la capacidad que tiene un cuerpo para regresar a su estado normal luego de haber resistido una presión. En la humanidad, se trata del poder para resistir con éxito los embates del medio ambiente y tener disposición, energía y claridad de propósito para enfrentar una mala realidad y tener logros a pesar de ella, e inclusive para aprovechar las oportunidades en esa realidad terrible.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Estar dispuesto a transitar entornos difíciles y crecer en ellos sin resentimiento, con inteligencia y valores humanos como la generosidad y la esperanza',
              'Contar con una red afectiva y profesional que colabore con tus objetivos',
              'Estar preparado, desde lo pragmático, hasta lo emocional, contando con las fortalezas que reconoces en ti mismo',
              'Tener capacidad de decir no a lo que no deseas, desde el punto de vista del negocio implica poder renunciar a los pesos innecesarios y enfocar la acción en las ideas y estrategias que más oportunidades tienen de ser exitosas',
              'Encontrar el balance espiritual y ético para contener sentimientos que suelen aflorar cuando sufrimos embates, como la soberbia, la venganza, el resentimiento y la maldad',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Exceso de confianza en las capacidades resilientes y entrar en entornos retadores y competitivos sin estar preparado como persona, profesional o emprendedor',
              'Tener un espejismo de resiliencia y sufrir deterioro moral, ético o espiritual al superar las adversidades',
              'Exponerse a la situación de adversidad por demasiado tiempo, llevando al extremo las capacidades de subsistencia empresarial o personal',
              'Justificar acciones fuera de la ética a partir de la adversidad',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        trabajoEnEquipo: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Trabajo en equipo”', bold: true },
              ' como la capacidad de integrar personas en torno a una idea, un proyecto, una promesa de valor o un objetivo. ',
              '\n\n',
              'Trabajar en equipo requiere impulsar una visión conjunta y cooperar compartiendo información y cargas de trabajo, cumplir con la responsabilidad propia y colaborar o co-crear con los demás para que el resultado sea superior a la simple suma de las partes.',
              '\n\n',
              'Los miembros de un equipo revisan resultados con frecuencia, celebran éxitos y asumen responsabilidades cuando las cosas no van bien, siempre moviéndose hacia adelante, tomando los errores como aprendizajes.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Apoyar tu liderazgo en el equipo con tus competencias de cooperación, influencia e integridad. El reconocimiento del equipo depende de tu consistencia tanto entre amigos, como en familia o en el trabajo',
              'Discutir las diferencias con respeto, pero sin temor a estar en desacuerdo',
              'Compartir la ruta prevista y reconocer los aportes y progresos que cada miembro del equipo va alcanzando',
              'Compartir la Visión y ejercitar la previsión de obstáculos y oportunidades para estar siempre preparados',
              'Integrar en tu agenda el hábito de conversar con tu equipo y compartir buenas prácticas',
              'Estar dispuesto a ofrecer ideas, conocimientos, buenas prácticas e información a tus compañeros',
              'Establecer una forma de medición de avances que sea conocida y compartida, con indicadores individuales y de desempeño conjunto',
              'Practicar la gratitud con tu equipo, comprendiendo la visión que cada uno aporta desde su particularidad como persona, profesional o líder',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'El exceso de una visión colectiva puede opacar individualidades lo cual es inconveniente para generar incentivos individuales',
              'Desbalance entre el tiempo que se dedica al equipo y el que se dedica al resto de los retos',
              'Dificultad para identificar detractores del equipo, aquellas personas que no cooperan, pero aprovechan los logros colectivos',
              'Perder la confianza del equipo por opacidad o incomunicación en relación con los temas que conciernen a todos',
              'Dejar de promover la participación y la creatividad',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        focoEnResultados: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Foco en resultados”', bold: true },
              ' como la capacidad de alcanzar logros con un ritmo firme y constante, superando los obstáculos que puedan surgir haciendo uso de todos los recursos disponibles. ',
              '\n\n',
              'El foco en los resultados es una virtud conduce a distinguir las distracciones y ponerlas de lado, siguiendo una ruta clara y previendo los recursos para alcanzarla. Quienes cuentan con esta competencia, suelen valerse de herramientas de planeación y control que facilitan la revisión de avances y la identificación de atrasos u obstáculos que se puedan prever.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Mantener una idea en mente y buscar los elementos y recursos que la hagan factible',
              'Crear el hábito de planificar y familiarizarse con herramientas que permitan registrar actividades, tiempos, recursos y responsabilidades',
              'Desarrollar disciplina y persistencia para el logro de los propósitos, e insistir hasta alcanzarlos',
              'Aprender a ser flexible cuando la ruta lo exige y así garantizar el resultado. Ser enfocado en resultados no implicar golpearse contra la misma pared',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Ganar estrés por exceso de exigencia y, tener frustración frecuente por metas incumplidas, especialmente en ambientes complejos',
              'Generar un ambiente familiar o de trabajo inflexible y hostil que solo reconoce avances cuantificables o hitos concretos',
              'Irrespetar los procesos, perder calidad o pasar por encima de opiniones y normativas por alcanzar resultados',
              'Dejar pasar otras oportunidades por la incapacidad de cambiar de foco',
              'Perder el valor de personas con características creativas o colaborativas cuyos aportes a los resultados son más innovadores o flexibles',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
      },
    },
    crecer: {
      strengths: {
        creatividad: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Creatividad”', bold: true },
              ' como la capacidad de idear con novedad, respuestas y soluciones frente a los retos o problemas.  Ser creativo implica enfocar la realidad con perspectivas originales que mezclan tendencias o aplican lógicas de otros ambientes al ecosistema propio.',
              '\n\n',
              'Las personas creativas ven el mundo con curiosidad y ven recursos donde otros no, y tienden a ser libres para expresar sus pensamientos o sentimientos en diferentes formas, desde el arte, hasta los negocios.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Retar las ideas con las que te sientes cómodo para dar paso a nuevas formas de ver el mundo. Preguntarte ¿Qué otra forma hay para resolver esto? ¿Cuál es la otra solución adecuada?',
              'Crear el hábito de conectar ideas, conocimientos o tendencias que aparentemente no se relacionan',
              'Encender tus neuronas con nuevos aprendizajes en temas que no te has atrevido a explorar o que son un reto para la humanidad como la sostenibilidad, la longevidad, la inteligencia artificial, etc.',
              'Interactuar con el arte en sus múltiples formas y dejar que los mensajes, emociones o parámetros influyan en tus ideas y la forma en que haces las cosas',
              'Acercarte o seguir a personas creativas, el arte de ser creativo es contagioso, si te dejas influir',
              'Tener conciencia de que para promover tus ideas necesitas traducirlas en un lenguaje que tu entorno comprenda',
            ],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Aplicar soluciones inadecuadas para problemas nuevos que requieren creatividad e innovación',
              'Hacer siempre lo mismo creando rutinas aburridas, ineficientes, no sostenibles',
              'Ser excesivamente disruptivo, innecesariamente retador, extravagante creando incomprensión o prejuicios por parte las personas en quienes quieres influir',
              'Crear soluciones avanzadas para tu tiempo, que requieren un cambio de paradigma previo',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        relacionamiento: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Extroversión”', bold: true },
              ' como la capacidad de relacionarse con las personas y los hechos de la vida con optimismo y apertura. Las personas extrovertidas conversan confiadamente con otras y compartes ideas con la expectativa de influir o simplemente intercambiar. Es la habilidad de interactuar con personas diversas y de aceptar paradigmas diferentes, la capacidad de probar cosas nuevas e incorporarlas al mundo propio.',
              '\n\n',
              'Las personas extrovertidas buscan a otros para nutrir su creatividad, aprecian diferentes formas de crear conocimiento, son curiosos y se aventuran a aprender y vivir en nuevas tendencias.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Crear el hábito de revisar tendencias en tu ámbito de conocimiento o en tu emprendimiento. Darte permiso para soñar y compartir los sueños',
              'Promover en ti mismo el disfrute de la conversación desestructurada, sin agenda, incorporando temas o personas nuevas y diferentes',
              'Disminuir los juicios que haces de lo que no se parece a ti, comenzando por las situaciones más cercanas, conversando con personas nuevas, en lugares diferentes. La oferta de conferencias, charlas, foros es una gran oportunidad',
              'Acercarte a lo creativo, al arte, el cine, la música o la literatura de otros países o de autores que no son los que ya tu cerebro acepta',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Pérdida de foco por dificultad para incorporar a la vida o al emprendimiento los nuevos conocimientos y lo diverso. Dejarse llevar por tendencias que no son adecuadas para las condiciones propias',
              'Engancharse en discusiones poco productivas por desacuerdo con nuevas tendencias',
              'Creer que las relaciones hacen los éxitos. Aunque ciertamente los facilitan, se requieren propuestas o ideas de valor, influyentes y bien sustentadas para que otros las compren',
              'Exceso de tiempo invertido en relacionamiento y exploración',
              'Pérdida de discreción respecto a temas que no es conveniente compartir. Exceso de planes y promesas que no se concretan',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        cooperacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Cooperación”', bold: true },
              ' como la capacidad de construir con otros generando valor compartido a partir del aprovechamiento conjunto de recursos, oportunidades y conocimientos. Implica poder generar relaciones balanceadas en la que varias personas o emprendimientos persiguen un objetivo común.',
              '\n\n',
              'La cooperación permite detectar fortalezas complementarias que son requeridas para crear nuevas realidades, se trata de apoyar, ayudar, aportar, contribuir con la confianza de que la acción de todos los involucrados es necesaria para transformar la realidad.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Fortalecer la práctica de crear relaciones equilibradas y de largo plazo, cooperar no es solo recibir, o dar, implica crear reglas del juego y ser el primero en respetarlas.',
              'Construir confianza compartiendo información y resultados. Es importante apuntar que la confianza se crea con el tiempo, a través del cumplimiento de los compromisos y el conocimiento mutuo.',
              'Practicar el hábito de escuchar y respetar otras formas de pensar. Abrir el debate de forma transparente exponiendo los desacuerdos para poder crear soluciones que tomen en cuenta la mayoría de las perspectivas.',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Ralentización por búsqueda de consensos absolutos. Intentar procesos complejos de cooperación sin metodologías para llegar a acuerdos',
              'No dar cabida a la expresión individual o aplastar a las minorías cuando se requiere tomar decisiones',
              'Descontrol de los proyectos o confusión respecto al objetivo por ausencia de liderazgos adecuados. La cooperación, además de ser una competencia para construir en equipo, es un reto para los líderes',
              'Pérdida de las ideas, soluciones, relaciones y recursos que otros pueden aportar. Especialmente, pérdida de su confianza',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        innovacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Innovación”', bold: true },
              ' como la habilidad de idear soluciones novedosas, disruptivas y factibles orientadas a las necesidades del mercado. Esta fortaleza permite que se cuestionen los paradigmas previos y aporta la capacidad de convocar y articular inteligencia, conocimiento, recursos y entusiasmo en torno a la satisfacción de necesidades y resolución de problemas con eficiencia y rentabilidad.',
              '\n\n',
              'Esta fortaleza se puede ver afectada cuando se trabaja en ambientes que castigan el error, o donde los lideres temen al cambio; la innovación tiende a desaparecer en espacios laborales con exceso de restricciones y libertades, con un gobierno corporativo poco flexible y cerrado a las tendencias.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Identifica tendencias y mejora tu acceso a información actual procedente de diferentes mundos y fuentes.',
              'Activa tus prácticas tecnológicas y la integración de tus actividades al mundo digital.',
              'Hazte un experto en las características del mercado en el que quieres innovar, identifica sus aspiraciones y paradigmas dominantes.',
              'Conéctate con personas interesadas en tendencias, mentes diferentes que reten tus creencias, aprovecha sus inteligencias para robustecer tu pensamiento y crear soluciones más competitivas y originales.',
            ],
            // margin: [20, 0, 0, 0]
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Puedes tener dificultades para aceptar y aprovechar lo nuevo.',
              'Te podrías olvidar de la importancia de la creatividad para hacer evolucionar tu vida.',
              'Podrías atascarte buscando la perfección dentro de un paradigma, sin notar que existen otros de mayor riqueza, potencial y oportunidad.',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        pragmatismo: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Pragmatismo”', bold: true },
              ' como la capacidad de interpretar la realidad a través de factores objetivos poniendo a un lado las emociones y pareceres imprecisos. El pragmatismo permite tomar de la realidad sus aspectos más verificables, compararlos y analizarlos para tomar decisiones frente a retos y dilemas de la vida y los negocios.',
              '\n\n',
              'Las personas pragmáticas son estructuradas, ordenadas y valoran la lógica; son analíticas y se sirven de datos e información fundamentada para convencer a otros y seleccionar alternativas, a la vez, dudan de las imprecisiones y las intuiciones.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Instalar la práctica de buscar información que soporte tus planteamientos, ideas, hipótesis o suposiciones. Esto implica identificar fuentes de información confiable: colegas, artículos de expertos, conferencias, institutos de investigación, etc.',
              'Hacer conciencia de tus emociones frente a una decisión y complementarla con elementos, casos, hechos o datos que le aporten realismo a tus ideas, propuestas e iniciativas',
              'Registrar hechos y datos de tus actividades, especialmente las relacionadas con tu proceso de reinvención. Esto proporciona estructura para revisar de manera más realista y objetiva las decisiones y los efectos en tu negocio',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Creer que sólo los datos describen al mundo. Aunque ciertamente éstos ayudan a describir problemas y realidades, los datos fríos no conducen al éxito, requieren la interpretación de una mente que sueñe e intuya y un corazón que aporte pasión',
              'Comunicación poco influyente con los demás: tu familia, colaboradores, jefes, amigos, aliados o equipos de trabajo, por falta de conexión emocional',
              'Descalificar otras aproximaciones a la realidad, más intuitivas, emotivas o creativas, perdiendo su valor y cometiendo errores',
              'Formular ideas poco factibles o hacer castillos en el aire, si las fundaciones necesarias',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        integridad: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Integridad”', bold: true },
              ' como la coherencia entre los valores que un líder postulan y las acciones que realiza. Esa coherencia inspira a otros, produce credibilidad y reputación, y aumenta la influencia. Es una gran ventaja tener la Integridad como fortaleza pues una de sus expresiones es la transparencia en la relación con los demás y en el manejo de recursos lo que crea confianza en tu entorno.',
              '\n\n',
              'Ser fiel a tus valores eleva tus probabilidades de tener una vida plena; aunque eventualmente te encuentres en situaciones difíciles donde debas defenderlos frente al estatus quo o frente al poder, siempre saldrás más fuerte al reafirmar tus convicciones.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Usarla como apoyo para liderar con el ejemplo',
              'Aplicar valores positivos en las ideas, los proyectos y emprendimientos',
              'Incorporar la perspectiva de la responsabilidad en tus actos, dejando de poner las causas de los fracasos fuera de ti',
              'Incluir valores de sostenibilidad en lo que haces, desde hacer crecer a tu familia, hasta emprender',
              'No dejar que las crisis y falsos dilemas te den excusas para doblegar tus valores',
              'prueba de texto',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Perder la credibilidad en lo personal y profesional',
              'Decepcionar a tus aliados, familiares, colaboradores o socios, que observen tus inconsistencias',
              'Debilitar tu reputación y afectar tus relaciones profesionales y personales',
              'Ser etiquetado junto a personas inconvenientes',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        creacionDeRedes: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Creación de redes”', bold: true },
              ' como la capacidad de relacionarse con personas del mundo profesional, en planos de confianza, con perspectivas de largo plazo. Se trata de una competencia que ha sido potenciada por las herramientas digitales y redes sociales, pero que va más allá, expresándose en la reputación y el posicionamiento de quien la posee.',
              '\n\n',
              'Las personas con la competencia “Creación de Redes” encuentran más fácilmente que otras, colaboradores para sus equipos, oportunidades de negocios, expertos o conocimientos de utilidad.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Dedicar tiempo a conocer nuevas personas cuyos talentos, intereses o posiciones coincidan con tu ruta como persona, emprendedor o profesional',
              'Crear el hábito de registrar en la agenda de contactos a las personas que conoces para poder contactarlas posteriormente',
              'Identificar oportunidades profesionales para conectar con tus redes aportando invitaciones o información de valor',
              'Mantener contacto más allá de las oportunidades puntuales compartiendo de forma bilateral, conversaciones de interés',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Pérdida de foco por exceso de tiempo dedicado al relacionamiento',
              'Creer que las redes sociales conducen al relacionamiento de calidad en forma automática. Para que el relacionamiento sea efectivo debe existir un valor que se intercambia',
              'Equivocar el posicionamiento y debilitar la credibilidad por uso indebido de la red, por ejemplo, aprovechándola o desgastándola con intereses netamente individuales',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        comunicacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Comunicación”', bold: true },
              ' como la capacidad de transmitir información, exponer ideas o manifestar opiniones con lucidez y discernimiento. Esta fortaleza responde a la necesidad de guiar, influir y convencer. Esta fortaleza es medular en los procesos de reinvención ya que: acelera tus nuevos objetivos al facilitar el acceso a recursos o apoyos, y también te otorga la virtud de la buena conversación, es decir, te permite escuchar conocimientos, experiencias y oportunidades que otros te compartan.',
              '\n\n',
              'Esta fortaleza se puede ver afectada por tus propios temores, inseguridades o ansiedades. También por factores externos como información distorsionada en el ambiente de las redes sociales por lo que es valioso poner tus ideas en orden, contar con información veraz, conocer los intereses de tu interlocutor y escuchar sin interrumpir.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Conocer tus audiencias e interlocutores, escuchar sus preocupaciones y dudas, saber sus expectativas',
              'Manejar el lenguaje general y específico en tu ambiente de negocios',
              'Leer el entorno, contar con información actualizada',
              'Conocerte, saber lo que ayuda y lo que deteriora tu comunicación',
              'Escribir bien, tener buena ortografía y calidad de redacción para ser comprendido por los lectores',
              'Siempre, haz un espacio para escuchar y ser amable',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Crear mensajes importantes para ti, pero sin valor para los demás',
              'Crear mensajes relevantes, pero transmitirlos sin influir en los demás',
              'Aburrir a otros que pueden ser aliados, socios y clientes que no se sientan inspirados o convocados por tus ideas',
              'Confundir influencia con manipulación creando ambientes de desconfianza y dañando la credibilidad que es el corazón del relacionamiento entre las personas',
              'Producir mensajes poco diferenciados o carentes de emoción, inspiración o empatía',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        estrategiaYCambio: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Adaptación al Cambio”', bold: true },
              ' como la flexibilidad y la firmeza que se expresan frente a las transformaciones, las crisis e imprevistos en nuestra vida, emprendimientos y negocios. Esta fortaleza lleva en sí misma el aprendizaje humano de la evolución y es una ventaja competitiva cuando las circunstancias son adversas e impredecibles. Reconocer los cambios, poderlos intuir o anticipar con información de calidad y aprovechando la experiencia es una cualidad superior para la reinvención y el emprendimiento.',
              '\n\n',
              'Esta fortaleza se puede ver afectada por creencias que dificultan el cambio como: “Todo tiempo pasado fue mejor” o “¿Para qué cambiar, si todo funciona bien?”. Ha características culturales que relacionan el éxito y la felicidad con la estabilidad, sin considerar que la estabilidad es un equilibrio inestable. El viaje de la reinvención se hace más cómodo y seguro si apelas a tus capacidades de adaptación, moviéndote al ritmo de los acontecimientos, manteniendo un propósito claro en tu mente y tu corazón.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'No temer a los cambios, aceptarlos como una señal de que estamos vivos. Sustituye el miedo por organización frente al cambio, infórmate, tu eliges cómo aprovecharlo, identifica cómo te afecta y mitiga los impactos. Movilízate',
              'Crear escenarios, imaginar qué variables de tu vida o empresa podrían cambiar. Tal vez conviene más promover el cambio que enfrentarlo',
              'Celebrar y abrazar las transformaciones que se dan dentro de ti, cuando se presenta un cambio en tu vida, es un momento para conocerte más, usar fuerzas que desconocías y soñar nuevas situaciones',
              'Aportar tu inteligencia crítica como combustible de la reinvención, vas a necesitar retar creencias relacionadas con la aceptación de lo nuevo y lo diverso, con la estabilidad y las reglas que “siempre han sido así”',
              'Informarte, escuchar expertos, colegas y amigos, analizar tus capacidades y ser muy honesto contigo mismo para saber cuán rápido es tu ritmo de adaptación, es indispensable conocerte bien para adaptarte, emprender y reinventarte',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Iniciar los procesos de cambio con exceso de energía y agotarla antes de llegar a un nuevo punto de estabilidad',
              'Subestimar la transformación y no prepararte para eventuales cambios súbitos que te dejan sin respuestas',
              'Asumir el cambio o las crisis con pánico como emoción dominante y permanente, tomando decisiones precipitadas y excesivamente arriesgadas',
              'Confundir adaptación al cambio con persecución constante de riesgos, una cosa es estar listo para los cambios y promover transformaciones; otras es entrar en riesgos innecesarios sin propósitos de valor',
              'Ser irreflexivo frente a creencias o paradigmas y tomarse con poca seriedad el peso del pasado, es importante cuestionarse y ser crítico sin perder las anclas de tu personalidad.',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        resiliencia: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Resiliencia”', bold: true },
              ' como la capacidad de superar la adversidad y responder a los imprevistos sin perder el rumbo, ni dejarse deteriorar. Es esa fuerza que te anima a poner la atención en un objetivo que se encuentra más allá de los obstáculos, que te moviliza a seguir luchando y ocupándote de alcanzar tus sueños sin que se erosionen la esperanza, la autoconfianza y los valores.',
              '\n\n',
              'La resiliencia tiene sus raíces en la física, definiéndose como la capacidad que tiene un cuerpo para regresar a su estado normal luego de haber resistido una presión. En la humanidad, se trata del poder para resistir con éxito los embates del medio ambiente y tener disposición, energía y claridad de propósito para enfrentar una mala realidad y tener logros a pesar de ella, e inclusive para aprovechar las oportunidades en esa realidad terrible.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Estar dispuesto a transitar entornos difíciles y crecer en ellos sin resentimiento, con inteligencia y valores humanos como la generosidad y la esperanza',
              'Contar con una red afectiva y profesional que colabore con tus objetivos',
              'Estar preparado, desde lo pragmático, hasta lo emocional, contando con las fortalezas que reconoces en ti mismo',
              'Tener capacidad de decir no a lo que no deseas, desde el punto de vista del negocio implica poder renunciar a los pesos innecesarios y enfocar la acción en las ideas y estrategias que más oportunidades tienen de ser exitosas',
              'Encontrar el balance espiritual y ético para contener sentimientos que suelen aflorar cuando sufrimos embates, como la soberbia, la venganza, el resentimiento y la maldad',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Exceso de confianza en las capacidades resilientes y entrar en entornos retadores y competitivos sin estar preparado como persona, profesional o emprendedor',
              'Tener un espejismo de resiliencia y sufrir deterioro moral, ético o espiritual al superar las adversidades',
              'Exponerse a la situación de adversidad por demasiado tiempo, llevando al extremo las capacidades de subsistencia empresarial o personal',
              'Justificar acciones fuera de la ética a partir de la adversidad',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        trabajoEnEquipo: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Trabajo en equipo”', bold: true },
              ' como la capacidad de integrar personas en torno a una idea, un proyecto, una promesa de valor o un objetivo. ',
              '\n\n',
              'Trabajar en equipo requiere impulsar una visión conjunta y cooperar compartiendo información y cargas de trabajo, cumplir con la responsabilidad propia y colaborar o co-crear con los demás para que el resultado sea superior a la simple suma de las partes.',
              '\n\n',
              'Los miembros de un equipo revisan resultados con frecuencia, celebran éxitos y asumen responsabilidades cuando las cosas no van bien, siempre moviéndose hacia adelante, tomando los errores como aprendizajes.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Apoyar tu liderazgo en el equipo con tus competencias de cooperación, influencia e integridad. El reconocimiento del equipo depende de tu consistencia tanto entre amigos, como en familia o en el trabajo',
              'Discutir las diferencias con respeto, pero sin temor a estar en desacuerdo',
              'Compartir la ruta prevista y reconocer los aportes y progresos que cada miembro del equipo va alcanzando',
              'Compartir la Visión y ejercitar la previsión de obstáculos y oportunidades para estar siempre preparados',
              'Integrar en tu agenda el hábito de conversar con tu equipo y compartir buenas prácticas',
              'Estar dispuesto a ofrecer ideas, conocimientos, buenas prácticas e información a tus compañeros',
              'Establecer una forma de medición de avances que sea conocida y compartida, con indicadores individuales y de desempeño conjunto',
              'Practicar la gratitud con tu equipo, comprendiendo la visión que cada uno aporta desde su particularidad como persona, profesional o líder',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'El exceso de una visión colectiva puede opacar individualidades lo cual es inconveniente para generar incentivos individuales',
              'Desbalance entre el tiempo que se dedica al equipo y el que se dedica al resto de los retos',
              'Dificultad para identificar detractores del equipo, aquellas personas que no cooperan, pero aprovechan los logros colectivos',
              'Perder la confianza del equipo por opacidad o incomunicación en relación con los temas que conciernen a todos',
              'Dejar de promover la participación y la creatividad',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        focoEnResultados: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Foco en resultados”', bold: true },
              ' como la capacidad de alcanzar logros con un ritmo firme y constante, superando los obstáculos que puedan surgir haciendo uso de todos los recursos disponibles. ',
              '\n\n',
              'El foco en los resultados es una virtud conduce a distinguir las distracciones y ponerlas de lado, siguiendo una ruta clara y previendo los recursos para alcanzarla. Quienes cuentan con esta competencia, suelen valerse de herramientas de planeación y control que facilitan la revisión de avances y la identificación de atrasos u obstáculos que se puedan prever.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Mantener una idea en mente y buscar los elementos y recursos que la hagan factible',
              'Crear el hábito de planificar y familiarizarse con herramientas que permitan registrar actividades, tiempos, recursos y responsabilidades',
              'Desarrollar disciplina y persistencia para el logro de los propósitos, e insistir hasta alcanzarlos',
              'Aprender a ser flexible cuando la ruta lo exige y así garantizar el resultado. Ser enfocado en resultados no implicar golpearse contra la misma pared',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Ganar estrés por exceso de exigencia y, tener frustración frecuente por metas incumplidas, especialmente en ambientes complejos',
              'Generar un ambiente familiar o de trabajo inflexible y hostil que solo reconoce avances cuantificables o hitos concretos',
              'Irrespetar los procesos, perder calidad o pasar por encima de opiniones y normativas por alcanzar resultados',
              'Dejar pasar otras oportunidades por la incapacidad de cambiar de foco',
              'Perder el valor de personas con características creativas o colaborativas cuyos aportes a los resultados son más innovadores o flexibles',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
      },
    },
    crear: {
      strengths: {
        creatividad: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Creatividad”', bold: true },
              ' como la capacidad de idear con novedad, respuestas y soluciones frente a los retos o problemas.  Ser creativo implica enfocar la realidad con perspectivas originales que mezclan tendencias o aplican lógicas de otros ambientes al ecosistema propio.',
              '\n\n',
              'Las personas creativas ven el mundo con curiosidad y ven recursos donde otros no, y tienden a ser libres para expresar sus pensamientos o sentimientos en diferentes formas, desde el arte, hasta los negocios.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Retar las ideas con las que te sientes cómodo para dar paso a nuevas formas de ver el mundo. Preguntarte ¿Qué otra forma hay para resolver esto? ¿Cuál es la otra solución adecuada?',
              'Crear el hábito de conectar ideas, conocimientos o tendencias que aparentemente no se relacionan',
              'Encender tus neuronas con nuevos aprendizajes en temas que no te has atrevido a explorar o que son un reto para la humanidad como la sostenibilidad, la longevidad, la inteligencia artificial, etc.',
              'Interactuar con el arte en sus múltiples formas y dejar que los mensajes, emociones o parámetros influyan en tus ideas y la forma en que haces las cosas',
              'Acercarte o seguir a personas creativas, el arte de ser creativo es contagioso, si te dejas influir',
              'Tener conciencia de que para promover tus ideas necesitas traducirlas en un lenguaje que tu entorno comprenda',
            ],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Aplicar soluciones inadecuadas para problemas nuevos que requieren creatividad e innovación',
              'Hacer siempre lo mismo creando rutinas aburridas, ineficientes, no sostenibles',
              'Ser excesivamente disruptivo, innecesariamente retador, extravagante creando incomprensión o prejuicios por parte las personas en quienes quieres influir',
              'Crear soluciones avanzadas para tu tiempo, que requieren un cambio de paradigma previo',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        relacionamiento: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Extroversión”', bold: true },
              ' como la capacidad de relacionarse con las personas y los hechos de la vida con optimismo y apertura. Las personas extrovertidas conversan confiadamente con otras y compartes ideas con la expectativa de influir o simplemente intercambiar. Es la habilidad de interactuar con personas diversas y de aceptar paradigmas diferentes, la capacidad de probar cosas nuevas e incorporarlas al mundo propio.',
              '\n\n',
              'Las personas extrovertidas buscan a otros para nutrir su creatividad, aprecian diferentes formas de crear conocimiento, son curiosos y se aventuran a aprender y vivir en nuevas tendencias.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Crear el hábito de revisar tendencias en tu ámbito de conocimiento o en tu emprendimiento. Darte permiso para soñar y compartir los sueños',
              'Promover en ti mismo el disfrute de la conversación desestructurada, sin agenda, incorporando temas o personas nuevas y diferentes',
              'Disminuir los juicios que haces de lo que no se parece a ti, comenzando por las situaciones más cercanas, conversando con personas nuevas, en lugares diferentes. La oferta de conferencias, charlas, foros es una gran oportunidad',
              'Acercarte a lo creativo, al arte, el cine, la música o la literatura de otros países o de autores que no son los que ya tu cerebro acepta',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Pérdida de foco por dificultad para incorporar a la vida o al emprendimiento los nuevos conocimientos y lo diverso. Dejarse llevar por tendencias que no son adecuadas para las condiciones propias',
              'Engancharse en discusiones poco productivas por desacuerdo con nuevas tendencias',
              'Creer que las relaciones hacen los éxitos. Aunque ciertamente los facilitan, se requieren propuestas o ideas de valor, influyentes y bien sustentadas para que otros las compren',
              'Exceso de tiempo invertido en relacionamiento y exploración',
              'Pérdida de discreción respecto a temas que no es conveniente compartir. Exceso de planes y promesas que no se concretan',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        cooperacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Cooperación”', bold: true },
              ' como la capacidad de construir con otros generando valor compartido a partir del aprovechamiento conjunto de recursos, oportunidades y conocimientos. Implica poder generar relaciones balanceadas en la que varias personas o emprendimientos persiguen un objetivo común.',
              '\n\n',
              'La cooperación permite detectar fortalezas complementarias que son requeridas para crear nuevas realidades, se trata de apoyar, ayudar, aportar, contribuir con la confianza de que la acción de todos los involucrados es necesaria para transformar la realidad.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Fortalecer la práctica de crear relaciones equilibradas y de largo plazo, cooperar no es solo recibir, o dar, implica crear reglas del juego y ser el primero en respetarlas.',
              'Construir confianza compartiendo información y resultados. Es importante apuntar que la confianza se crea con el tiempo, a través del cumplimiento de los compromisos y el conocimiento mutuo.',
              'Practicar el hábito de escuchar y respetar otras formas de pensar. Abrir el debate de forma transparente exponiendo los desacuerdos para poder crear soluciones que tomen en cuenta la mayoría de las perspectivas.',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Ralentización por búsqueda de consensos absolutos. Intentar procesos complejos de cooperación sin metodologías para llegar a acuerdos',
              'No dar cabida a la expresión individual o aplastar a las minorías cuando se requiere tomar decisiones',
              'Descontrol de los proyectos o confusión respecto al objetivo por ausencia de liderazgos adecuados. La cooperación, además de ser una competencia para construir en equipo, es un reto para los líderes',
              'Pérdida de las ideas, soluciones, relaciones y recursos que otros pueden aportar. Especialmente, pérdida de su confianza',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        innovacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Innovación”', bold: true },
              ' como la habilidad de idear soluciones novedosas, disruptivas y factibles orientadas a las necesidades del mercado. Esta fortaleza permite que se cuestionen los paradigmas previos y aporta la capacidad de convocar y articular inteligencia, conocimiento, recursos y entusiasmo en torno a la satisfacción de necesidades y resolución de problemas con eficiencia y rentabilidad.',
              '\n\n',
              'Esta fortaleza se puede ver afectada cuando se trabaja en ambientes que castigan el error, o donde los lideres temen al cambio; la innovación tiende a desaparecer en espacios laborales con exceso de restricciones y libertades, con un gobierno corporativo poco flexible y cerrado a las tendencias.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Identifica tendencias y mejora tu acceso a información actual procedente de diferentes mundos y fuentes.',
              'Activa tus prácticas tecnológicas y la integración de tus actividades al mundo digital.',
              'Hazte un experto en las características del mercado en el que quieres innovar, identifica sus aspiraciones y paradigmas dominantes.',
              'Conéctate con personas interesadas en tendencias, mentes diferentes que reten tus creencias, aprovecha sus inteligencias para robustecer tu pensamiento y crear soluciones más competitivas y originales.',
            ],
            // margin: [20, 0, 0, 0]
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Puedes tener dificultades para aceptar y aprovechar lo nuevo.',
              'Te podrías olvidar de la importancia de la creatividad para hacer evolucionar tu vida.',
              'Podrías atascarte buscando la perfección dentro de un paradigma, sin notar que existen otros de mayor riqueza, potencial y oportunidad.',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        pragmatismo: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Pragmatismo”', bold: true },
              ' como la capacidad de interpretar la realidad a través de factores objetivos poniendo a un lado las emociones y pareceres imprecisos. El pragmatismo permite tomar de la realidad sus aspectos más verificables, compararlos y analizarlos para tomar decisiones frente a retos y dilemas de la vida y los negocios.',
              '\n\n',
              'Las personas pragmáticas son estructuradas, ordenadas y valoran la lógica; son analíticas y se sirven de datos e información fundamentada para convencer a otros y seleccionar alternativas, a la vez, dudan de las imprecisiones y las intuiciones.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Instalar la práctica de buscar información que soporte tus planteamientos, ideas, hipótesis o suposiciones. Esto implica identificar fuentes de información confiable: colegas, artículos de expertos, conferencias, institutos de investigación, etc.',
              'Hacer conciencia de tus emociones frente a una decisión y complementarla con elementos, casos, hechos o datos que le aporten realismo a tus ideas, propuestas e iniciativas',
              'Registrar hechos y datos de tus actividades, especialmente las relacionadas con tu proceso de reinvención. Esto proporciona estructura para revisar de manera más realista y objetiva las decisiones y los efectos en tu negocio',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Creer que sólo los datos describen al mundo. Aunque ciertamente éstos ayudan a describir problemas y realidades, los datos fríos no conducen al éxito, requieren la interpretación de una mente que sueñe e intuya y un corazón que aporte pasión',
              'Comunicación poco influyente con los demás: tu familia, colaboradores, jefes, amigos, aliados o equipos de trabajo, por falta de conexión emocional',
              'Descalificar otras aproximaciones a la realidad, más intuitivas, emotivas o creativas, perdiendo su valor y cometiendo errores',
              'Formular ideas poco factibles o hacer castillos en el aire, si las fundaciones necesarias',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        integridad: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Integridad”', bold: true },
              ' como la coherencia entre los valores que un líder postulan y las acciones que realiza. Esa coherencia inspira a otros, produce credibilidad y reputación, y aumenta la influencia. Es una gran ventaja tener la Integridad como fortaleza pues una de sus expresiones es la transparencia en la relación con los demás y en el manejo de recursos lo que crea confianza en tu entorno.',
              '\n\n',
              'Ser fiel a tus valores eleva tus probabilidades de tener una vida plena; aunque eventualmente te encuentres en situaciones difíciles donde debas defenderlos frente al estatus quo o frente al poder, siempre saldrás más fuerte al reafirmar tus convicciones.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Usarla como apoyo para liderar con el ejemplo',
              'Aplicar valores positivos en las ideas, los proyectos y emprendimientos',
              'Incorporar la perspectiva de la responsabilidad en tus actos, dejando de poner las causas de los fracasos fuera de ti',
              'Incluir valores de sostenibilidad en lo que haces, desde hacer crecer a tu familia, hasta emprender',
              'No dejar que las crisis y falsos dilemas te den excusas para doblegar tus valores',
              'prueba de texto',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Perder la credibilidad en lo personal y profesional',
              'Decepcionar a tus aliados, familiares, colaboradores o socios, que observen tus inconsistencias',
              'Debilitar tu reputación y afectar tus relaciones profesionales y personales',
              'Ser etiquetado junto a personas inconvenientes',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        creacionDeRedes: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Creación de redes”', bold: true },
              ' como la capacidad de relacionarse con personas del mundo profesional, en planos de confianza, con perspectivas de largo plazo. Se trata de una competencia que ha sido potenciada por las herramientas digitales y redes sociales, pero que va más allá, expresándose en la reputación y el posicionamiento de quien la posee.',
              '\n\n',
              'Las personas con la competencia “Creación de Redes” encuentran más fácilmente que otras, colaboradores para sus equipos, oportunidades de negocios, expertos o conocimientos de utilidad.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Dedicar tiempo a conocer nuevas personas cuyos talentos, intereses o posiciones coincidan con tu ruta como persona, emprendedor o profesional',
              'Crear el hábito de registrar en la agenda de contactos a las personas que conoces para poder contactarlas posteriormente',
              'Identificar oportunidades profesionales para conectar con tus redes aportando invitaciones o información de valor',
              'Mantener contacto más allá de las oportunidades puntuales compartiendo de forma bilateral, conversaciones de interés',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Pérdida de foco por exceso de tiempo dedicado al relacionamiento',
              'Creer que las redes sociales conducen al relacionamiento de calidad en forma automática. Para que el relacionamiento sea efectivo debe existir un valor que se intercambia',
              'Equivocar el posicionamiento y debilitar la credibilidad por uso indebido de la red, por ejemplo, aprovechándola o desgastándola con intereses netamente individuales',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        comunicacion: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Comunicación”', bold: true },
              ' como la capacidad de transmitir información, exponer ideas o manifestar opiniones con lucidez y discernimiento. Esta fortaleza responde a la necesidad de guiar, influir y convencer. Esta fortaleza es medular en los procesos de reinvención ya que: acelera tus nuevos objetivos al facilitar el acceso a recursos o apoyos, y también te otorga la virtud de la buena conversación, es decir, te permite escuchar conocimientos, experiencias y oportunidades que otros te compartan.',
              '\n\n',
              'Esta fortaleza se puede ver afectada por tus propios temores, inseguridades o ansiedades. También por factores externos como información distorsionada en el ambiente de las redes sociales por lo que es valioso poner tus ideas en orden, contar con información veraz, conocer los intereses de tu interlocutor y escuchar sin interrumpir.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Conocer tus audiencias e interlocutores, escuchar sus preocupaciones y dudas, saber sus expectativas',
              'Manejar el lenguaje general y específico en tu ambiente de negocios',
              'Leer el entorno, contar con información actualizada',
              'Conocerte, saber lo que ayuda y lo que deteriora tu comunicación',
              'Escribir bien, tener buena ortografía y calidad de redacción para ser comprendido por los lectores',
              'Siempre, haz un espacio para escuchar y ser amable',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Crear mensajes importantes para ti, pero sin valor para los demás',
              'Crear mensajes relevantes, pero transmitirlos sin influir en los demás',
              'Aburrir a otros que pueden ser aliados, socios y clientes que no se sientan inspirados o convocados por tus ideas',
              'Confundir influencia con manipulación creando ambientes de desconfianza y dañando la credibilidad que es el corazón del relacionamiento entre las personas',
              'Producir mensajes poco diferenciados o carentes de emoción, inspiración o empatía',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        estrategiaYCambio: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Adaptación al Cambio”', bold: true },
              ' como la flexibilidad y la firmeza que se expresan frente a las transformaciones, las crisis e imprevistos en nuestra vida, emprendimientos y negocios. Esta fortaleza lleva en sí misma el aprendizaje humano de la evolución y es una ventaja competitiva cuando las circunstancias son adversas e impredecibles. Reconocer los cambios, poderlos intuir o anticipar con información de calidad y aprovechando la experiencia es una cualidad superior para la reinvención y el emprendimiento.',
              '\n\n',
              'Esta fortaleza se puede ver afectada por creencias que dificultan el cambio como: “Todo tiempo pasado fue mejor” o “¿Para qué cambiar, si todo funciona bien?”. Ha características culturales que relacionan el éxito y la felicidad con la estabilidad, sin considerar que la estabilidad es un equilibrio inestable. El viaje de la reinvención se hace más cómodo y seguro si apelas a tus capacidades de adaptación, moviéndote al ritmo de los acontecimientos, manteniendo un propósito claro en tu mente y tu corazón.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'No temer a los cambios, aceptarlos como una señal de que estamos vivos. Sustituye el miedo por organización frente al cambio, infórmate, tu eliges cómo aprovecharlo, identifica cómo te afecta y mitiga los impactos. Movilízate',
              'Crear escenarios, imaginar qué variables de tu vida o empresa podrían cambiar. Tal vez conviene más promover el cambio que enfrentarlo',
              'Celebrar y abrazar las transformaciones que se dan dentro de ti, cuando se presenta un cambio en tu vida, es un momento para conocerte más, usar fuerzas que desconocías y soñar nuevas situaciones',
              'Aportar tu inteligencia crítica como combustible de la reinvención, vas a necesitar retar creencias relacionadas con la aceptación de lo nuevo y lo diverso, con la estabilidad y las reglas que “siempre han sido así”',
              'Informarte, escuchar expertos, colegas y amigos, analizar tus capacidades y ser muy honesto contigo mismo para saber cuán rápido es tu ritmo de adaptación, es indispensable conocerte bien para adaptarte, emprender y reinventarte',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Iniciar los procesos de cambio con exceso de energía y agotarla antes de llegar a un nuevo punto de estabilidad',
              'Subestimar la transformación y no prepararte para eventuales cambios súbitos que te dejan sin respuestas',
              'Asumir el cambio o las crisis con pánico como emoción dominante y permanente, tomando decisiones precipitadas y excesivamente arriesgadas',
              'Confundir adaptación al cambio con persecución constante de riesgos, una cosa es estar listo para los cambios y promover transformaciones; otras es entrar en riesgos innecesarios sin propósitos de valor',
              'Ser irreflexivo frente a creencias o paradigmas y tomarse con poca seriedad el peso del pasado, es importante cuestionarse y ser crítico sin perder las anclas de tu personalidad.',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        resiliencia: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Resiliencia”', bold: true },
              ' como la capacidad de superar la adversidad y responder a los imprevistos sin perder el rumbo, ni dejarse deteriorar. Es esa fuerza que te anima a poner la atención en un objetivo que se encuentra más allá de los obstáculos, que te moviliza a seguir luchando y ocupándote de alcanzar tus sueños sin que se erosionen la esperanza, la autoconfianza y los valores.',
              '\n\n',
              'La resiliencia tiene sus raíces en la física, definiéndose como la capacidad que tiene un cuerpo para regresar a su estado normal luego de haber resistido una presión. En la humanidad, se trata del poder para resistir con éxito los embates del medio ambiente y tener disposición, energía y claridad de propósito para enfrentar una mala realidad y tener logros a pesar de ella, e inclusive para aprovechar las oportunidades en esa realidad terrible.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Estar dispuesto a transitar entornos difíciles y crecer en ellos sin resentimiento, con inteligencia y valores humanos como la generosidad y la esperanza',
              'Contar con una red afectiva y profesional que colabore con tus objetivos',
              'Estar preparado, desde lo pragmático, hasta lo emocional, contando con las fortalezas que reconoces en ti mismo',
              'Tener capacidad de decir no a lo que no deseas, desde el punto de vista del negocio implica poder renunciar a los pesos innecesarios y enfocar la acción en las ideas y estrategias que más oportunidades tienen de ser exitosas',
              'Encontrar el balance espiritual y ético para contener sentimientos que suelen aflorar cuando sufrimos embates, como la soberbia, la venganza, el resentimiento y la maldad',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Exceso de confianza en las capacidades resilientes y entrar en entornos retadores y competitivos sin estar preparado como persona, profesional o emprendedor',
              'Tener un espejismo de resiliencia y sufrir deterioro moral, ético o espiritual al superar las adversidades',
              'Exponerse a la situación de adversidad por demasiado tiempo, llevando al extremo las capacidades de subsistencia empresarial o personal',
              'Justificar acciones fuera de la ética a partir de la adversidad',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        trabajoEnEquipo: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Trabajo en equipo”', bold: true },
              ' como la capacidad de integrar personas en torno a una idea, un proyecto, una promesa de valor o un objetivo. ',
              '\n\n',
              'Trabajar en equipo requiere impulsar una visión conjunta y cooperar compartiendo información y cargas de trabajo, cumplir con la responsabilidad propia y colaborar o co-crear con los demás para que el resultado sea superior a la simple suma de las partes.',
              '\n\n',
              'Los miembros de un equipo revisan resultados con frecuencia, celebran éxitos y asumen responsabilidades cuando las cosas no van bien, siempre moviéndose hacia adelante, tomando los errores como aprendizajes.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Apoyar tu liderazgo en el equipo con tus competencias de cooperación, influencia e integridad. El reconocimiento del equipo depende de tu consistencia tanto entre amigos, como en familia o en el trabajo',
              'Discutir las diferencias con respeto, pero sin temor a estar en desacuerdo',
              'Compartir la ruta prevista y reconocer los aportes y progresos que cada miembro del equipo va alcanzando',
              'Compartir la Visión y ejercitar la previsión de obstáculos y oportunidades para estar siempre preparados',
              'Integrar en tu agenda el hábito de conversar con tu equipo y compartir buenas prácticas',
              'Estar dispuesto a ofrecer ideas, conocimientos, buenas prácticas e información a tus compañeros',
              'Establecer una forma de medición de avances que sea conocida y compartida, con indicadores individuales y de desempeño conjunto',
              'Practicar la gratitud con tu equipo, comprendiendo la visión que cada uno aporta desde su particularidad como persona, profesional o líder',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'El exceso de una visión colectiva puede opacar individualidades lo cual es inconveniente para generar incentivos individuales',
              'Desbalance entre el tiempo que se dedica al equipo y el que se dedica al resto de los retos',
              'Dificultad para identificar detractores del equipo, aquellas personas que no cooperan, pero aprovechan los logros colectivos',
              'Perder la confianza del equipo por opacidad o incomunicación en relación con los temas que conciernen a todos',
              'Dejar de promover la participación y la creatividad',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
        focoEnResultados: {
          description: {
            text: [
              'Definimos la fortaleza ',
              { text: '“Foco en resultados”', bold: true },
              ' como la capacidad de alcanzar logros con un ritmo firme y constante, superando los obstáculos que puedan surgir haciendo uso de todos los recursos disponibles. ',
              '\n\n',
              'El foco en los resultados es una virtud conduce a distinguir las distracciones y ponerlas de lado, siguiendo una ruta clara y previendo los recursos para alcanzarla. Quienes cuentan con esta competencia, suelen valerse de herramientas de planeación y control que facilitan la revisión de avances y la identificación de atrasos u obstáculos que se puedan prever.',
            ],
            alignment: 'center',
          },
          listOne: {
            ul: [
              'Mantener una idea en mente y buscar los elementos y recursos que la hagan factible',
              'Crear el hábito de planificar y familiarizarse con herramientas que permitan registrar actividades, tiempos, recursos y responsabilidades',
              'Desarrollar disciplina y persistencia para el logro de los propósitos, e insistir hasta alcanzarlos',
              'Aprender a ser flexible cuando la ruta lo exige y así garantizar el resultado. Ser enfocado en resultados no implicar golpearse contra la misma pared',
            ],
            // margin: [20, 0, 0, 0],
            style: 'subMarginListOneSectionEnergizeStrength',
          },
          listTwo: {
            ul: [
              'Ganar estrés por exceso de exigencia y, tener frustración frecuente por metas incumplidas, especialmente en ambientes complejos',
              'Generar un ambiente familiar o de trabajo inflexible y hostil que solo reconoce avances cuantificables o hitos concretos',
              'Irrespetar los procesos, perder calidad o pasar por encima de opiniones y normativas por alcanzar resultados',
              'Dejar pasar otras oportunidades por la incapacidad de cambiar de foco',
              'Perder el valor de personas con características creativas o colaborativas cuyos aportes a los resultados son más innovadores o flexibles',
            ],
            //   margin: [20, 0, 0, 0],
            style: 'subMarginListTwoSectionEnergizeStrength',
          },
        },
      },
    },
  },
};
