const utils = require('../utils/utils');
const aspectReinventationService = require('../services/aspectReinventation');

exports.getAspectReinventation = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await aspectReinventationService.getAspectReinventation(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.getResults = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await aspectReinventationService.getResults(userId);

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
