const utils = require('../utils/utils');
const services = require('../services/cardinal-power');

exports.get = async (_, res) => {
  try {
    const data = await services.get();

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
