const utils = require('../utils/utils');
const giftService = require('../services/gift');

exports.get = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const {
    moment,
  } = req.query;

  try {
    const data = await giftService.get({
      userId, moment,
    });

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.viewedGift = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const {
    giftId,
  } = req.body;
  try {
    const data = await giftService.viewedGift(userId, giftId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
