const utils = require('../utils/utils');
const userStrengthService = require('../services/userStrength');

exports.getUserStrengths = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  try {
    const data = await userStrengthService.getUserStrengths(userId);

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.updateValuesUserStrengths = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { strengthIds = [] } = req.body;

  if (!strengthIds) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await userStrengthService.updateValuesUserStrengths(strengthIds, userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.setActiveUserStrengths = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  try {
    const data = await userStrengthService.setActiveUserStrengths(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.getMobileText = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { strengthId = '' } = req.params;

  if (!strengthId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await userStrengthService.getMobileText(userId, strengthId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
