module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('strengths', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    name: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'name',
    },
    info: {
      type: Sequelize.STRING(512),
      field: 'info',
    },
    cardinalPowerId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'cardinal_powers',
        key: 'id',
      },
      field: 'cardinal_power_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('strengths'),
};
