module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('users', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    firstName: {
      type: Sequelize.STRING,
      field: 'first_name',
    },
    lastName: {
      type: Sequelize.STRING,
      field: 'last_name',
    },
    gender: {
      type: Sequelize.ENUM('F', 'M'),
      field: 'gender',
    },
    countryId: {
      type: Sequelize.INTEGER,
      references: {
        model: 'countries',
        key: 'id',
      },
      field: 'country_id',
    },
    educationalLevelId: {
      type: Sequelize.INTEGER,
      references: {
        model: 'educational_levels',
        key: 'id',
      },
      field: 'educational_level_id',
    },
    phone: {
      type: Sequelize.STRING,
      field: 'phone',
    },
    email: {
      type: Sequelize.STRING,
      field: 'email',
    },
    password: {
      type: Sequelize.TEXT,
      field: 'password',
    },
    city: {
      type: Sequelize.STRING,
      field: 'city',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
    deletedAt: {
      type: Sequelize.DATE,
      field: 'deleted_at',
    },
    confirmedEmail: {
      type: Sequelize.DATE,
      field: 'confirmed_email',
    },
    validationCodeEmail: {
      type: Sequelize.STRING(6),
      field: 'validation_code_email',
    },
    expirationCodeEmail: {
      type: Sequelize.DATE,
      field: 'expiration_code_email',
    },
    validationCodeResetPassword: {
      type: Sequelize.STRING(6),
      field: 'validation_code_reset_password',
    },
    expirationCodeResetPassword: {
      type: Sequelize.DATE,
      field: 'expiration_code_reset_password',
    },
  }),
  down: queryInterface => queryInterface.dropTable('users'),
};
