module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('questionnaries', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id',
      },
      field: 'user_id',
    },
    suscriptionTypeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'suscription_types',
        key: 'id',
      },
      field: 'suscription_type_id',
    },
    cardinalPowerId: {
      type: Sequelize.INTEGER,
      references: {
        model: 'cardinal_powers',
        key: 'id',
      },
      field: 'cardinal_power_id',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
    deletedAt: {
      type: Sequelize.DATE,
      field: 'deleted_at',
    },
  }),
  down: queryInterface => queryInterface.dropTable('questionnaries'),
};
