module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_preferences', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id',
      },
      field: 'user_id',
    },
    preferenceId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'preferences',
        key: 'id',
      },
      field: 'preference_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_preferences'),
};
