module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('challenge_strengths', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    strengthId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'strengths',
        key: 'id',
      },
      field: 'strength_id',
    },
    challengeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'challenges',
        key: 'id',
      },
      field: 'challenge_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('challenge_strengths'),
};
