module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_powerful_questions', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userAspectReinventationId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'user_aspects_reinventation',
        key: 'id',
      },
      field: 'user_aspect_reinventation_id',
    },
    powerfulQuestionId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'powerful_questions',
        key: 'id',
      },
      field: 'powerful_question_id',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
    deletedAt: {
      type: Sequelize.DATE,
      field: 'deleted_at',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_powerful_questions'),
};
