module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('users', 'initial_suscription_type_id', {
        allowNull: true,
        type: Sequelize.INTEGER,
        references: {
          model: 'suscription_types',
          key: 'id',
        },
        field: 'initial_suscription_type_id',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('users', 'initial_suscription_type_id');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
