module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('user_challenges', 'user_id', {
        allowNull: true,
        type: Sequelize.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      });
      await queryInterface.addColumn('user_challenges', 'current', {
        type: Sequelize.INTEGER,
        defaultValue: 0,
        field: 'current',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('user_challenges', 'user_id');
      await queryInterface.removeColumn('user_challenges', 'current');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
