module.exports = {
  up: async (queryInterface) => {
    try {
      await queryInterface.removeColumn('user_actions_plan', 'completed');
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('user_actions_plan', 'completed', {
        type: Sequelize.DATE,
        allowNull: true,
        field: 'completed',
      });
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
