module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('routes', 'long_name', {
        allowNull: true,
        type: Sequelize.STRING,
        field: 'long_name',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('routes', 'long_name');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
