module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_device_token', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id',
      },
      field: 'user_id',
    },
    deviceToken: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'device_token',
    },
    deviceOS: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'device_os',
    },
    deviceVersion: {
      type: Sequelize.STRING,
      field: 'device_version',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_device_token'),
};
