module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('user_suscriptions', 'transaction_id', {
        allowNull: true,
        type: Sequelize.STRING(255),
        field: 'transaction_id',
      });
      await queryInterface.addColumn('user_suscriptions', 'transaction_data', {
        allowNull: true,
        type: Sequelize.TEXT,
        field: 'transaction_data',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('user_suscriptions', 'transaction_id');
      await queryInterface.removeColumn('user_suscriptions', 'transaction_data');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
