module.exports = (sequelize, DataTypes) => {
  const ActionPlan = sequelize.define(
    'ActionPlan',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      link: {
        type: DataTypes.TEXT,
        field: 'link',
      },
      challengeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'actions_plan',
    },
  );
  ActionPlan.associate = models => {
    ActionPlan.belongsToMany(models.UserAspectReinventation, {
      through: 'UserActionPlan',
      foreignKey: 'actionPlanId',
      as: 'userAspectReinventation',
      timestamps: false,
    });

    ActionPlan.belongsTo(models.Challenge, {
      foreignKey: 'challengeId',
      as: 'challenge',
    });

    ActionPlan.hasMany(models.UserActionPlan, {
      foreignKey: 'actionPlanId',
      as: 'userActionPlan',
    });
  };
  return ActionPlan;
};
