module.exports = (sequelize, DataTypes) => {
  const BehaviorPoint = sequelize.define(
    'BehaviorPoint',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      category: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'category',
      },
      weight: {
        allowNull: false,
        type: DataTypes.DECIMAL(3, 2),
        field: 'weight',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'behavior_points',
    },
  );
  BehaviorPoint.associate = models => {
    BehaviorPoint.belongsToMany(models.Questionnarie, {
      through: 'QuestionnarieBehavior',
      foreignKey: 'behaviorPointId',
      as: 'questionnarieBehavior',
      timestamps: false,
    });

    BehaviorPoint.belongsToMany(models.Behavior, {
      through: 'QuestionnarieBehavior',
      foreignKey: 'behaviorPointId',
      as: 'behavior',
      timestamps: false,
    });
  };
  return BehaviorPoint;
};
