module.exports = (sequelize, DataTypes) => {
  const CoachingReason = sequelize.define(
    'CoachingReason',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'coaching_reasons',
    },
  );
  CoachingReason.associate = models => {
    CoachingReason.hasMany(models.User, {
      foreignKey: 'coachingReasonId',
      as: 'user',
    });
  };
  return CoachingReason;
};
