module.exports = (sequelize, DataTypes) => {
  const PromotionalType = sequelize.define(
    'PromotionalType',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      dsc: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'dsc',
      },
      suscriptionTypeId: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'suscription_type_id',
      },
      promotionType: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'type',
      },
      androidProductId: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'google_id_product',
      },
      iosProductId: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'apple_id_product',
      },
      pomotionid: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'promotionid',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'promotional_code_types',
    },
  );
  PromotionalType.associate = models => {
    PromotionalType.hasMany(models.PromotionalCode, {
      foreignKey: 'promCodeTypeId',
    });

  };
  return PromotionalType;
};
