module.exports = (sequelize, DataTypes) => {
  const QuestionnarieBehavior = sequelize.define(
    'QuestionnarieBehavior',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      questionnarieId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'questionnaries',
          key: 'id',
        },
        field: 'questionnarie_id',
      },
      behaviorId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'behaviors',
          key: 'id',
        },
        field: 'behavior_id',
      },
      behaviorPointId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'behavior_points',
          key: 'id',
        },
        field: 'behavior_point_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'questionnarie_behaviors',
    },
  );
  QuestionnarieBehavior.associate = models => {
    QuestionnarieBehavior.belongsTo(models.Questionnarie, {
      foreignKey: 'questionnarieId',
    });
    QuestionnarieBehavior.belongsTo(models.Behavior, {
      foreignKey: 'behaviorId',
    });
    QuestionnarieBehavior.belongsTo(models.BehaviorPoint, {
      foreignKey: 'behaviorPointId',
    });
  };
  return QuestionnarieBehavior;
};
