module.exports = (sequelize, DataTypes) => {
  const Questionnarie = sequelize.define(
    'Questionnarie',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      suscriptionTypeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'suscription_types',
          key: 'id',
        },
        field: 'suscription_type_id',
      },
      cardinalPowerId: {
        type: DataTypes.INTEGER,
        references: {
          model: 'cardinal_powers',
          key: 'id',
        },
        field: 'cardinal_power_id',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'questionnaries',
    },
  );
  Questionnarie.associate = models => {
    Questionnarie.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
    Questionnarie.belongsTo(models.SuscriptionType, {
      foreignKey: 'suscriptionTypeId',
      as: 'suscriptionType',
    });
    Questionnarie.belongsTo(models.CardinalPower, {
      foreignKey: 'cardinalPowerId',
      as: 'cardinalPower',
    });
    Questionnarie.belongsToMany(models.Behavior, {
      through: 'QuestionnarieBehavior',
      foreignKey: 'questionnarieId',
      as: 'behavior',
      timestamps: false,
    });
    Questionnarie.belongsToMany(models.BehaviorPoint, {
      through: 'QuestionnarieBehavior',
      foreignKey: 'questionnarieId',
      as: 'behaviorPoint',
      timestamps: false,
    });
  };
  return Questionnarie;
};
