module.exports = (sequelize, DataTypes) => {
  const Route = sequelize.define(
    'Route',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      info: {
        allowNull: false,
        type: DataTypes.TEXT,
        field: 'info',
      },
      longName: {
        type: DataTypes.STRING,
        field: 'long_name',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'routes',
    },
  );
  Route.associate = models => {
    Route.belongsToMany(models.User, {
      through: 'UserRoute',
      foreignKey: 'routeId',
      as: 'user',
      timestamps: false,
    });
    Route.hasMany(models.Challenge, {
      foreignKey: 'routeId',
      as: 'challenge',
    });
    Route.hasMany(models.RouteStrength, {
      foreignKey: 'routeId',
      as: 'routeStrengths',
    });
    Route.hasMany(models.Gift, {
      foreignKey: 'routeId',
      as: 'gifts',
    });
  };
  return Route;
};
